/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.junitxmlformatter.EscapingXmlStreamWriter;
import io.cucumber.junitxmlformatter.XmlReportData;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

class XmlReportWriter {
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
    private final XmlReportData data;

    XmlReportWriter(XmlReportData data) {
        this.data = data;
    }

    void writeXmlReport(Writer out) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        EscapingXmlStreamWriter writer = new EscapingXmlStreamWriter(factory.createXMLStreamWriter(out));
        writer.writeStartDocument("UTF-8", "1.0");
        writer.newLine();
        this.writeTestsuite(this.data, writer);
        writer.writeEndDocument();
        writer.flush();
    }

    private void writeTestsuite(XmlReportData data, EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("testsuite");
        this.writeSuiteAttributes(writer);
        writer.newLine();
        for (String testCaseStartedId : data.testCaseStartedIds()) {
            this.writeTestcase(writer, testCaseStartedId);
        }
        writer.writeEndElement();
        writer.newLine();
    }

    private void writeSuiteAttributes(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("name", "Cucumber");
        writer.writeAttribute("time", this.numberFormat.format(this.data.getSuiteDurationInSeconds()));
        Map<TestStepResultStatus, Long> counts = this.data.getTestCaseStatusCounts();
        writer.writeAttribute("tests", String.valueOf(this.data.getTestCaseCount()));
        writer.writeAttribute("skipped", counts.getOrDefault(TestStepResultStatus.SKIPPED, 0L).toString());
        writer.writeAttribute("failures", String.valueOf(XmlReportWriter.countFailures(counts)));
        writer.writeAttribute("errors", "0");
    }

    private static long countFailures(Map<TestStepResultStatus, Long> counts) {
        return XmlReportWriter.createNotPassedNotSkippedSet().stream().mapToLong(s -> counts.getOrDefault(s, 0L)).sum();
    }

    private static EnumSet<TestStepResultStatus> createNotPassedNotSkippedSet() {
        EnumSet<TestStepResultStatus> notPassedNotSkipped = EnumSet.allOf(TestStepResultStatus.class);
        notPassedNotSkipped.remove(TestStepResultStatus.PASSED);
        notPassedNotSkipped.remove(TestStepResultStatus.SKIPPED);
        return notPassedNotSkipped;
    }

    private void writeTestcase(EscapingXmlStreamWriter writer, String id) throws XMLStreamException {
        writer.writeStartElement("testcase");
        this.writeTestCaseAttributes(writer, id);
        writer.newLine();
        this.writeNonPassedElement(writer, id);
        this.writeStepAndResultList(writer, id);
        writer.writeEndElement();
        writer.newLine();
    }

    private void writeTestCaseAttributes(EscapingXmlStreamWriter writer, String id) throws XMLStreamException {
        writer.writeAttribute("classname", this.data.getFeatureName(id));
        writer.writeAttribute("name", this.data.getPickleName(id));
        writer.writeAttribute("time", this.numberFormat.format(this.data.getDurationInSeconds(id)));
    }

    private void writeNonPassedElement(EscapingXmlStreamWriter writer, String id) throws XMLStreamException {
        TestStepResult result = this.data.getTestCaseStatus(id);
        TestStepResultStatus status = result.getStatus();
        if (status == TestStepResultStatus.PASSED) {
            return;
        }
        String elementName = status == TestStepResultStatus.SKIPPED ? "skipped" : "failure";
        Optional message = result.getMessage();
        Optional<String> exceptionType = result.getException().map(Exception::getType);
        Optional exceptionMessage = result.getException().flatMap(Exception::getMessage);
        if (message.isPresent()) {
            writer.writeStartElement(elementName);
        } else {
            writer.writeEmptyElement(elementName);
        }
        if (status != TestStepResultStatus.SKIPPED && exceptionType.isPresent()) {
            writer.writeAttribute("type", exceptionType.get());
        }
        if (exceptionMessage.isPresent()) {
            writer.writeAttribute("message", (String)exceptionMessage.get());
        }
        if (message.isPresent()) {
            writer.newLine();
            writer.writeCData((String)message.get());
            writer.newLine();
        }
        if (message.isPresent()) {
            writer.writeEndElement();
        }
        writer.newLine();
    }

    private void writeStepAndResultList(EscapingXmlStreamWriter writer, String id) throws XMLStreamException {
        List<Map.Entry<String, String>> results = this.data.getStepsAndResult(id);
        if (results.isEmpty()) {
            return;
        }
        writer.writeStartElement("system-out");
        writer.writeCData(XmlReportWriter.createStepResultList(results));
        writer.writeEndElement();
        writer.newLine();
    }

    private static String createStepResultList(List<Map.Entry<String, String>> results) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        results.forEach(r -> {
            String stepText = (String)r.getKey();
            String status = (String)r.getValue();
            sb.append(stepText);
            sb.append(".");
            for (int i = 75 - stepText.length(); i > 0; --i) {
                sb.append(".");
            }
            sb.append(status);
            sb.append("\n");
        });
        return sb.toString();
    }
}

