/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.junitxmlformatter.EscapingXmlStreamWriter;
import io.cucumber.junitxmlformatter.XmlReportData;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;

class XmlReportWriter {
    private final XmlReportData data;

    XmlReportWriter(XmlReportData data) {
        this.data = data;
    }

    void writeXmlReport(Writer out) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        EscapingXmlStreamWriter writer = new EscapingXmlStreamWriter(factory.createXMLStreamWriter(out));
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeNewLine();
        this.writeTestsuite(writer);
        writer.writeEndDocument();
        writer.flush();
    }

    private void writeTestsuite(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("testsuite");
        this.writeSuiteAttributes(writer);
        writer.writeNewLine();
        for (TestCaseStarted testCaseStarted : this.data.getAllTestCaseStarted()) {
            this.writeTestcase(writer, testCaseStarted);
        }
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private void writeSuiteAttributes(EscapingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("name", this.data.getTestSuiteName());
        writer.writeAttribute("time", String.valueOf(this.data.getSuiteDurationInSeconds()));
        Map<TestStepResultStatus, Long> counts = this.data.getTestCaseStatusCounts();
        writer.writeAttribute("tests", String.valueOf(this.data.getTestCaseCount()));
        writer.writeAttribute("skipped", String.valueOf(counts.get(TestStepResultStatus.SKIPPED)));
        writer.writeAttribute("failures", String.valueOf(XmlReportWriter.countFailures(counts)));
        writer.writeAttribute("errors", "0");
        Optional<String> testRunStartedAt = this.data.getTestRunStartedAt();
        if (testRunStartedAt.isPresent()) {
            writer.writeAttribute("timestamp", testRunStartedAt.get());
        }
    }

    private static long countFailures(Map<TestStepResultStatus, Long> counts) {
        return XmlReportWriter.createNotPassedNotSkippedSet().stream().mapToLong(counts::get).sum();
    }

    private static EnumSet<TestStepResultStatus> createNotPassedNotSkippedSet() {
        EnumSet<TestStepResultStatus> notPassedNotSkipped = EnumSet.allOf(TestStepResultStatus.class);
        notPassedNotSkipped.remove(TestStepResultStatus.PASSED);
        notPassedNotSkipped.remove(TestStepResultStatus.SKIPPED);
        return notPassedNotSkipped;
    }

    private void writeTestcase(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted) throws XMLStreamException {
        writer.writeStartElement("testcase");
        this.writeTestCaseAttributes(writer, testCaseStarted);
        writer.writeNewLine();
        this.writeNonPassedElement(writer, testCaseStarted);
        this.writeStepAndResultList(writer, testCaseStarted);
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private void writeTestCaseAttributes(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted) throws XMLStreamException {
        writer.writeAttribute("classname", this.data.getTestClassName(testCaseStarted));
        writer.writeAttribute("name", this.data.getTestName(testCaseStarted));
        writer.writeAttribute("time", String.valueOf(this.data.getDurationInSeconds(testCaseStarted)));
    }

    private void writeNonPassedElement(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted) throws XMLStreamException {
        boolean hasMessageOrStackTrace;
        TestStepResult result = this.data.getTestCaseStatus(testCaseStarted);
        TestStepResultStatus status = result.getStatus();
        if (status == TestStepResultStatus.PASSED) {
            return;
        }
        String elementName = status == TestStepResultStatus.SKIPPED ? "skipped" : "failure";
        Optional message = result.getMessage();
        Optional<String> exceptionType = result.getException().map(Exception::getType);
        Optional exceptionMessage = result.getException().flatMap(Exception::getMessage);
        Optional exceptionStackTrace = result.getException().flatMap(Exception::getStackTrace);
        boolean bl = hasMessageOrStackTrace = message.isPresent() || exceptionStackTrace.isPresent();
        if (hasMessageOrStackTrace) {
            writer.writeStartElement(elementName);
        } else {
            writer.writeEmptyElement(elementName);
        }
        if (status != TestStepResultStatus.SKIPPED && exceptionType.isPresent()) {
            writer.writeAttribute("type", exceptionType.get());
        }
        if (exceptionMessage.isPresent()) {
            writer.writeAttribute("message", (String)exceptionMessage.get());
        }
        if (hasMessageOrStackTrace) {
            if (exceptionStackTrace.isPresent()) {
                writer.writeNewLine();
                writer.writeCData((String)exceptionStackTrace.get());
                writer.writeNewLine();
            } else {
                writer.writeNewLine();
                writer.writeCData((String)message.get());
                writer.writeNewLine();
            }
        }
        if (hasMessageOrStackTrace) {
            writer.writeEndElement();
        }
        writer.writeNewLine();
    }

    private void writeStepAndResultList(EscapingXmlStreamWriter writer, TestCaseStarted testCaseStarted) throws XMLStreamException {
        List<Map.Entry<String, String>> results = this.data.getStepsAndResult(testCaseStarted);
        if (results.isEmpty()) {
            return;
        }
        writer.writeStartElement("system-out");
        writer.writeCData(XmlReportWriter.createStepResultList(results));
        writer.writeEndElement();
        writer.writeNewLine();
    }

    private static String createStepResultList(List<Map.Entry<String, String>> results) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        results.forEach(r -> {
            String stepText = (String)r.getKey();
            String status = (String)r.getValue();
            sb.append(stepText);
            sb.append("..");
            sb.append(".".repeat(Math.max(0, 74 - stepText.length())));
            sb.append(status);
            sb.append("\n");
        });
        return sb.toString();
    }
}

