/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.c21e.Exe;
import io.cucumber.c21e.ExeFile;
import io.cucumber.gherkin.GherkinException;
import io.cucumber.messages.Messages;
import io.cucumber.messages.ProtobufStreamIterable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Gherkin {
    private final List<String> paths;
    private final List<Messages.Source> sources;
    private final boolean includeSource;
    private final boolean includeAst;
    private final boolean includePickles;

    private Gherkin(List<String> paths, List<Messages.Source> sources, boolean includeSource, boolean includeAst, boolean includePickles) {
        this.paths = paths;
        this.sources = sources;
        this.includeSource = includeSource;
        this.includeAst = includeAst;
        this.includePickles = includePickles;
    }

    public static Iterable<Messages.Envelope> fromPaths(List<String> paths, boolean includeSource, boolean includeAst, boolean includePickles) {
        return new Gherkin(paths, null, includeSource, includeAst, includePickles).messages();
    }

    public static Iterable<Messages.Envelope> fromSources(List<Messages.Source> sources, boolean includeSource, boolean includeAst, boolean includePickles) {
        return new Gherkin(Collections.emptyList(), sources, includeSource, includeAst, includePickles).messages();
    }

    public Iterable<Messages.Envelope> messages() {
        try {
            Exe exe = Gherkin.makeExe();
            ArrayList<String> args = new ArrayList<String>();
            if (!this.includeSource) {
                args.add("--no-source");
            }
            if (!this.includeAst) {
                args.add("--no-ast");
            }
            if (!this.includePickles) {
                args.add("--no-pickles");
            }
            args.addAll(this.paths);
            InputStream gherkinStdout = exe.execute(args, this.getSourcesStream());
            ProtobufStreamIterable streamIterable = new ProtobufStreamIterable(gherkinStdout);
            return this.wrapIterable(streamIterable, exe);
        }
        catch (IOException e) {
            throw new GherkinException("Couldn't execute gherkin", e);
        }
    }

    private Iterable<Messages.Envelope> wrapIterable(final Iterable<Messages.Envelope> streamIterable, final Exe exe) {
        return new Iterable<Messages.Envelope>(){

            @Override
            public Iterator<Messages.Envelope> iterator() {
                final Iterator iterator = streamIterable.iterator();
                return new Iterator<Messages.Envelope>(){

                    @Override
                    public boolean hasNext() {
                        boolean hasNext = iterator.hasNext();
                        if (!hasNext) {
                            try {
                                exe.waitFor();
                            }
                            catch (IOException | InterruptedException e) {
                                throw new GherkinException("Failed waiting for gherkin", e);
                            }
                        }
                        return hasNext;
                    }

                    @Override
                    public Messages.Envelope next() {
                        return (Messages.Envelope)iterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Exe makeExe() {
        return new Exe(new ExeFile(new File("executables"), "gherkin-{{.OS}}-{{.Arch}}{{.Ext}}"));
    }

    private InputStream getSourcesStream() throws IOException {
        if (this.sources == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Messages.Source source : this.sources) {
            Messages.Envelope.newBuilder().setSource(source).build().writeDelimitedTo(baos);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

