/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.c21e;

import io.cucumber.c21e.ExeException;
import io.cucumber.c21e.ExeFile;
import io.cucumber.c21e.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class Exe {
    private final ExeFile exeFile;
    private Process process;
    private File stderrFile;
    private File file;

    public Exe(ExeFile exeFile) {
        this.exeFile = exeFile;
    }

    public InputStream execute(List<String> args, InputStream stdin) throws IOException {
        this.file = this.exeFile.extract();
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(this.file.getAbsolutePath());
        allArgs.addAll(args);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(allArgs);
        this.stderrFile = File.createTempFile("stderr-", ".log");
        this.stderrFile.deleteOnExit();
        processBuilder.redirectError(this.stderrFile);
        this.process = processBuilder.start();
        if (stdin != null) {
            OutputStream processStdin = this.process.getOutputStream();
            IO.copy(stdin, processStdin);
            processStdin.flush();
            processStdin.close();
        }
        return this.process.getInputStream();
    }

    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
        if (this.process.exitValue() != 0) {
            byte[] stderr = Files.readAllBytes(this.stderrFile.toPath());
            throw new ExeException(String.format("Error executing %s.\nSTDERR:%s", this.file.getAbsolutePath(), new String(stderr, StandardCharsets.UTF_8)));
        }
    }
}

