/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin.exe;

import io.cucumber.gherkin.IO;
import io.cucumber.gherkin.exe.ExeException;
import io.cucumber.gherkin.exe.ExeFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class Exe {
    private final ExeFile exeFile;

    public Exe(ExeFile exeFile) {
        this.exeFile = exeFile;
    }

    public InputStream execute(List<String> args, InputStream stdin) throws IOException, InterruptedException {
        File exe = this.exeFile.extract();
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(exe.getAbsolutePath());
        allArgs.addAll(args);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(allArgs);
        File stderrFile = File.createTempFile("stderr-", ".log");
        stderrFile.deleteOnExit();
        processBuilder.redirectError(stderrFile);
        Process process = processBuilder.start();
        if (stdin != null) {
            OutputStream processStdin = process.getOutputStream();
            IO.copy(stdin, processStdin);
            processStdin.flush();
            processStdin.close();
        }
        InputStream processStdout = process.getInputStream();
        process.waitFor();
        if (process.exitValue() != 0) {
            byte[] stderr = Files.readAllBytes(stderrFile.toPath());
            throw new ExeException(String.format("Error executing %s.\nSTDERR:%s", exe.getAbsolutePath(), new String(stderr, "UTF-8")));
        }
        return processStdout;
    }
}

