/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.GherkinDialect;
import gherkin.IGherkinDialectProvider;
import gherkin.ParserException;
import gherkin.ast.Location;
import gherkin.deps.com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public class GherkinDialectProvider
implements IGherkinDialectProvider {
    private static Map<String, Map<String, List<String>>> DIALECTS;
    private final String default_dialect_name;

    public GherkinDialectProvider(String default_dialect_name) {
        this.default_dialect_name = default_dialect_name;
    }

    public GherkinDialectProvider() {
        this("en");
    }

    @Override
    public GherkinDialect getDefaultDialect() {
        return this.getDialect(this.default_dialect_name, null);
    }

    @Override
    public GherkinDialect getDialect(String language, Location location) {
        Map<String, List<String>> map = DIALECTS.get(language);
        if (map == null) {
            throw new ParserException.NoSuchLanguageException(language, location);
        }
        return new GherkinDialect(language, map);
    }

    static {
        Gson gson = new Gson();
        try {
            InputStreamReader dialects = new InputStreamReader(GherkinDialectProvider.class.getResourceAsStream("gherkin-languages.json"), "UTF-8");
            DIALECTS = (Map)gson.fromJson((Reader)dialects, Map.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

