/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.Stdio;
import gherkin.TokenMatcher;
import gherkin.ast.GherkinDocument;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.pickles.Compiler;
import gherkin.pickles.Pickle;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class GeneratePickles {
    public static void main(String[] args) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Parser<GherkinDocument> parser = new Parser<GherkinDocument>(new AstBuilder());
        TokenMatcher matcher = new TokenMatcher();
        Compiler compiler = new Compiler();
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        for (String fileName : args) {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8");
            try {
                GherkinDocument gherkinDocument = parser.parse(in, (Parser.ITokenMatcher)matcher);
                pickles.addAll(compiler.compile(gherkinDocument, fileName));
            }
            catch (ParserException e) {
                Stdio.err.println(e.getMessage());
                System.exit(1);
            }
        }
        Stdio.out.println(gson.toJson(pickles));
    }
}

