/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.Stdio;
import gherkin.TokenMatcher;
import gherkin.ast.GherkinDocument;
import gherkin.deps.com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class GenerateAst {
    public static void main(String[] args) throws IOException {
        Gson gson = new Gson();
        Parser<GherkinDocument> parser = new Parser<GherkinDocument>(new AstBuilder());
        TokenMatcher matcher = new TokenMatcher();
        long startTime = System.currentTimeMillis();
        for (String fileName : args) {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8");
            try {
                GherkinDocument gherkinDocument = parser.parse(in, (Parser.ITokenMatcher)matcher);
                Stdio.out.println(gson.toJson((Object)gherkinDocument));
            }
            catch (ParserException e) {
                Stdio.err.println(e.getMessage());
                System.exit(1);
            }
        }
        long endTime = System.currentTimeMillis();
        if (System.getenv("GHERKIN_PERF") != null) {
            Stdio.err.println(endTime - startTime);
        }
    }
}

