/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.TypeFactory;
import java.lang.reflect.Type;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class UndefinedDataTableTypeException
extends CucumberDataTableException {
    private UndefinedDataTableTypeException(String message) {
        super(message);
    }

    static UndefinedDataTableTypeException singletonNoConverterDefined(Type type) {
        return new UndefinedDataTableTypeException(String.format("Can't convert DataTable to %s.\nPlease register a DataTableType with a TableTransformer, TableEntryTransformer or TableRowTransformer for %s.", TypeFactory.typeName(type), TypeFactory.typeName(type)));
    }

    static CucumberDataTableException singletonTableTooWide(Type itemType, String missingConverter, Type typeToRegister) {
        return new UndefinedDataTableTypeException(String.format("Can't convert DataTable to %s.\nThere was a table cell converter but the table was too wide to use it.\nPlease reduce the table width or register a %s for %s.\n", TypeFactory.typeName(itemType), missingConverter, TypeFactory.typeName(typeToRegister)));
    }

    static UndefinedDataTableTypeException mapNoConverterDefined(Type keyType, Type valueType, String missingConverter, Type typeToRegister) {
        return new UndefinedDataTableTypeException(String.format("Can't convert DataTable to Map<%s, %s>.\nPlease register a DataTableType with a %s for %s.", TypeFactory.typeName(keyType), TypeFactory.typeName(valueType), missingConverter, TypeFactory.typeName(typeToRegister)));
    }

    static UndefinedDataTableTypeException mapsNoConverterDefined(Type keyType, Type valueType, Type typeToRegister) {
        return new UndefinedDataTableTypeException(String.format("Can't convert DataTable to List<Map<%s, %s>>.\nPlease register a DataTableType with a TableCellTransformer for %s.", TypeFactory.typeName(keyType), TypeFactory.typeName(valueType), TypeFactory.typeName(typeToRegister)));
    }

    static CucumberDataTableException listNoConverterDefined(Type itemType, String missingConverter, Type typeToRegister) {
        return new UndefinedDataTableTypeException(String.format("Can't convert DataTable to List<%s>.\nYou can register a DataTableType using DataTableType.entry(%s.class).\nFor more control you can define your own DataTableType with a %s for %s.\n", TypeFactory.typeName(itemType), TypeFactory.typeName(typeToRegister), missingConverter, TypeFactory.typeName(typeToRegister)));
    }

    static CucumberDataTableException listTableTooWide(Type itemType, String missingConverter, Type typeToRegister) {
        return new UndefinedDataTableTypeException(String.format("Can't convert DataTable to List<%s>.\nThere was a table cell converter but the table was too wide to use it.\nPlease reduce the table width or register a %s for %s.\n", TypeFactory.typeName(itemType), missingConverter, TypeFactory.typeName(typeToRegister)));
    }

    static CucumberDataTableException listsNoConverterDefined(Type itemType) {
        return new UndefinedDataTableTypeException(String.format("Can't convert DataTable to List<List<%s>>.\nPlease register a DataTableType with a TableCellTransformer for %s.", TypeFactory.typeName(itemType), TypeFactory.typeName(itemType)));
    }
}

