/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.TablePrinter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;

public final class DataTable {
    private final List<List<String>> raw;
    private final TableConverter tableConverter;

    private DataTable(List<List<String>> raw, TableConverter tableConverter) {
        if (raw == null) {
            throw new NullPointerException("cells can not be null");
        }
        if (tableConverter == null) {
            throw new NullPointerException("tableConverter can not be null");
        }
        this.raw = raw;
        this.tableConverter = tableConverter;
    }

    public static DataTable create(List<List<String>> raw) {
        return DataTable.create(raw, new NoConverterDefined());
    }

    public static DataTable create(List<List<String>> raw, TableConverter tableConverter) {
        return new DataTable(DataTable.copy(DataTable.requireNonNullEntries(DataTable.requireRectangularTable(raw))), tableConverter);
    }

    private static List<List<String>> copy(List<List<String>> balanced) {
        ArrayList rawCopy = new ArrayList(balanced.size());
        for (List<String> row : balanced) {
            if (row.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> rowCopy = new ArrayList<String>(row.size());
            rowCopy.addAll(row);
            rawCopy.add(Collections.unmodifiableList(rowCopy));
        }
        return Collections.unmodifiableList(rawCopy);
    }

    private static List<List<String>> requireNonNullEntries(List<List<String>> raw) {
        int rowIndex = 0;
        for (List<String> row : raw) {
            int columnIndex = row.indexOf(null);
            if (columnIndex >= 0) {
                throw new IllegalArgumentException("raw contained null at row: " + rowIndex + " column: " + columnIndex);
            }
            ++rowIndex;
        }
        return raw;
    }

    private static List<List<String>> requireRectangularTable(List<List<String>> table) {
        int columns = table.isEmpty() ? 0 : table.get(0).size();
        for (List<String> row : table) {
            if (columns == row.size()) continue;
            throw new IllegalArgumentException(String.format("Table is not rectangular: expected %s column(s) but found %s.", columns, row.size()));
        }
        return table;
    }

    public static DataTable emptyDataTable() {
        return new DataTable(Collections.emptyList(), new NoConverterDefined());
    }

    public List<String> asList() {
        return new ListView();
    }

    public <T> List<T> asList(Type itemType) {
        return this.tableConverter.toList(this, itemType);
    }

    public List<List<String>> asLists() {
        return this.cells();
    }

    public List<List<String>> cells() {
        return this.raw;
    }

    public <T> List<List<T>> asLists(Type itemType) {
        return this.tableConverter.toLists(this, itemType);
    }

    public <K, V> Map<K, V> asMap(Type keyType, Type valueType) {
        return this.tableConverter.toMap(this, keyType, valueType);
    }

    public List<Map<String, String>> asMaps() {
        if (this.raw.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> headers = this.raw.get(0);
        ArrayList headersAndRows = new ArrayList();
        for (int i = 1; i < this.raw.size(); ++i) {
            List<String> row = this.raw.get(i);
            LinkedHashMap<String, String> headersAndRow = new LinkedHashMap<String, String>();
            for (int j = 0; j < headers.size(); ++j) {
                String replaced = headersAndRow.put(headers.get(j), row.get(j));
                if (replaced == null) continue;
                throw CucumberDataTableException.duplicateKeyException(String.class, String.class, headers.get(j), row.get(j), replaced);
            }
            headersAndRows.add(Collections.unmodifiableMap(headersAndRow));
        }
        return Collections.unmodifiableList(headersAndRows);
    }

    public <K, V> List<Map<K, V>> asMaps(Type keyType, Type valueType) {
        return this.tableConverter.toMaps(this, keyType, valueType);
    }

    public String cell(int row, int column) {
        DataTable.rangeCheckRow(row, this.height());
        DataTable.rangeCheckColumn(column, this.width());
        return this.raw.get(row).get(column);
    }

    private static void rangeCheck(int index, int size) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index: " + index + ", Size: " + size);
        }
    }

    private static void rangeCheckRow(int row, int height) {
        if (row < 0 || row >= height) {
            throw new IndexOutOfBoundsException("row: " + row + ", Height: " + height);
        }
    }

    private static void rangeCheckColumn(int column, int width) {
        if (column < 0 || column >= width) {
            throw new IndexOutOfBoundsException("column: " + column + ", Width: " + width);
        }
    }

    public List<String> column(int column) {
        return new ColumnView(column);
    }

    public DataTable columns(int fromColumn) {
        return this.columns(fromColumn, this.width());
    }

    public DataTable columns(int fromColumn, int toColumn) {
        return this.subTable(0, fromColumn, this.height(), toColumn);
    }

    public <T> T convert(Type type, boolean transposed) {
        return this.tableConverter.convert(this, type, transposed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTable dataTable = (DataTable)o;
        return this.raw.equals(dataTable.raw);
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    public List<String> row(int row) {
        DataTable.rangeCheckRow(row, this.height());
        return this.raw.get(row);
    }

    public DataTable rows(int fromRow) {
        return this.rows(fromRow, this.height());
    }

    public DataTable rows(int fromRow, int toRow) {
        return this.subTable(fromRow, 0, toRow, this.width());
    }

    public DataTable subTable(int fromRow, int fromColumn) {
        return this.subTable(fromRow, fromColumn, this.height(), this.width());
    }

    public DataTable subTable(int fromRow, int fromColumn, int toRow, int toColumn) {
        return new DataTable(new RawDataTableView(fromRow, fromColumn, toColumn, toRow), this.tableConverter);
    }

    public int height() {
        return this.raw.size();
    }

    public int width() {
        return this.raw.isEmpty() ? 0 : this.raw.get(0).size();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.print(result);
        return result.toString();
    }

    public void print(Appendable appendable) throws IOException {
        TablePrinter printer = new TablePrinter();
        printer.printTable(this.raw, appendable);
    }

    public void print(StringBuilder appendable) {
        TablePrinter printer = new TablePrinter();
        printer.printTable(this.raw, appendable);
    }

    public DataTable transpose() {
        if (this.raw instanceof TransposedRawDataTableView) {
            TransposedRawDataTableView transposed = (TransposedRawDataTableView)this.raw;
            return transposed.dataTable();
        }
        return new DataTable(new TransposedRawDataTableView(), this.tableConverter);
    }

    private final class TransposedRawDataTableView
    extends AbstractList<List<String>>
    implements RandomAccess {
        private TransposedRawDataTableView() {
        }

        DataTable dataTable() {
            return DataTable.this;
        }

        @Override
        public List<String> get(final int row) {
            DataTable.rangeCheckRow(row, this.size());
            return new AbstractList<String>(){

                @Override
                public String get(int column) {
                    DataTable.rangeCheckColumn(column, this.size());
                    return (String)((List)DataTable.this.raw.get(column)).get(row);
                }

                @Override
                public int size() {
                    return DataTable.this.height();
                }
            };
        }

        @Override
        public int size() {
            return DataTable.this.width();
        }
    }

    private final class ColumnView
    extends AbstractList<String>
    implements RandomAccess {
        private final int column;

        ColumnView(int column) {
            DataTable.rangeCheckColumn(column, DataTable.this.width());
            this.column = column;
        }

        @Override
        public String get(int row) {
            DataTable.rangeCheckRow(row, this.size());
            return (String)((List)DataTable.this.raw.get(row)).get(this.column);
        }

        @Override
        public int size() {
            return DataTable.this.height();
        }
    }

    private final class ListView
    extends AbstractList<String> {
        int width;
        int height;

        private ListView() {
            this.width = DataTable.this.width();
            this.height = DataTable.this.height();
        }

        @Override
        public String get(int index) {
            DataTable.rangeCheck(index, this.size());
            return (String)((List)DataTable.this.raw.get(index / this.width)).get(index % this.width);
        }

        @Override
        public int size() {
            return this.height * this.width;
        }
    }

    private final class RawDataTableView
    extends AbstractList<List<String>>
    implements RandomAccess {
        private final int fromRow;
        private final int fromColumn;
        private final int toColumn;
        private final int toRow;

        RawDataTableView(int fromRow, int fromColumn, int toColumn, int toRow) {
            if (fromRow < 0) {
                throw new IndexOutOfBoundsException("fromRow: " + fromRow);
            }
            if (fromColumn < 0) {
                throw new IndexOutOfBoundsException("fromColumn: " + fromColumn);
            }
            if (toRow > DataTable.this.height()) {
                throw new IndexOutOfBoundsException("toRow: " + toRow + ", Height: " + DataTable.this.height());
            }
            if (toColumn > DataTable.this.width()) {
                throw new IndexOutOfBoundsException("toColumn: " + toColumn + ", Width: " + DataTable.this.width());
            }
            if (fromRow > toRow) {
                throw new IllegalArgumentException("fromRow(" + fromRow + ") > toRow(" + toRow + ")");
            }
            if (fromColumn > toColumn) {
                throw new IllegalArgumentException("fromColumn(" + fromColumn + ") > toColumn(" + toColumn + ")");
            }
            this.fromRow = fromRow;
            this.fromColumn = fromColumn;
            this.toColumn = toColumn;
            this.toRow = toRow;
        }

        @Override
        public List<String> get(final int row) {
            DataTable.rangeCheckRow(row, this.size());
            return new AbstractList<String>(){

                @Override
                public String get(int column) {
                    DataTable.rangeCheckColumn(column, this.size());
                    return (String)((List)DataTable.this.raw.get(RawDataTableView.this.fromRow + row)).get(RawDataTableView.this.fromColumn + column);
                }

                @Override
                public int size() {
                    return RawDataTableView.this.toColumn - RawDataTableView.this.fromColumn;
                }
            };
        }

        @Override
        public int size() {
            return this.fromColumn == this.toColumn ? 0 : this.toRow - this.fromRow;
        }
    }

    static final class NoConverterDefined
    implements TableConverter {
        NoConverterDefined() {
        }

        @Override
        public <T> T convert(DataTable dataTable, Type type) {
            return this.convert(dataTable, type, false);
        }

        @Override
        public <T> T convert(DataTable dataTable, Type type, boolean transposed) {
            throw new CucumberDataTableException(String.format("Can't convert DataTable to %s. DataTable was created without a converter", type));
        }

        @Override
        public <T> List<T> toList(DataTable dataTable, Type itemType) {
            throw new CucumberDataTableException(String.format("Can't convert DataTable to List<%s>. DataTable was created without a converter", itemType));
        }

        @Override
        public <T> List<List<T>> toLists(DataTable dataTable, Type itemType) {
            throw new CucumberDataTableException(String.format("Can't convert DataTable to List<List<%s>>. DataTable was created without a converter", itemType));
        }

        @Override
        public <K, V> Map<K, V> toMap(DataTable dataTable, Type keyType, Type valueType) {
            throw new CucumberDataTableException(String.format("Can't convert DataTable to Map<%s,%s>. DataTable was created without a converter", keyType, valueType));
        }

        @Override
        public <K, V> List<Map<K, V>> toMaps(DataTable dataTable, Type keyType, Type valueType) {
            throw new CucumberDataTableException(String.format("Can't convert DataTable to List<Map<%s,%s>>. DataTable was created without a converter", keyType, valueType));
        }
    }

    static abstract class AbstractTableConverter
    implements TableConverter {
        AbstractTableConverter() {
        }

        static Type listItemType(Type type) {
            return AbstractTableConverter.typeArg(type, List.class, 0);
        }

        static Type typeArg(Type type, Class<?> wantedRawType, int index) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type rawType = parameterizedType.getRawType();
                if (rawType instanceof Class && wantedRawType.isAssignableFrom((Class)rawType)) {
                    Type result = parameterizedType.getActualTypeArguments()[index];
                    if (result instanceof TypeVariable) {
                        throw new CucumberDataTableException("Generic types must be explicit");
                    }
                    return result;
                }
                return null;
            }
            return null;
        }

        static Type mapKeyType(Type type) {
            return AbstractTableConverter.typeArg(type, Map.class, 0);
        }

        static Type mapValueType(Type type) {
            return AbstractTableConverter.typeArg(type, Map.class, 1);
        }
    }

    public static interface TableConverter {
        public <T> T convert(DataTable var1, Type var2);

        public <T> T convert(DataTable var1, Type var2, boolean var3);

        public <T> List<T> toList(DataTable var1, Type var2);

        public <T> List<List<T>> toLists(DataTable var1, Type var2);

        public <K, V> Map<K, V> toMap(DataTable var1, Type var2, Type var3);

        public <K, V> List<Map<K, V>> toMaps(DataTable var1, Type var2, Type var3);
    }
}

