/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testng;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.SynchronizedEventBus;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.UuidGeneratorServiceLoader;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.testng.CucumberExceptionWrapper;
import io.cucumber.testng.CucumberPropertiesProvider;
import io.cucumber.testng.FeatureWrapperImpl;
import io.cucumber.testng.Pickle;
import io.cucumber.testng.PickleWrapperImpl;
import io.cucumber.testng.TestCaseResultObserver;
import io.cucumber.testng.TestNGCucumberOptionsProvider;
import java.time.Clock;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class TestNGCucumberRunner {
    private final Predicate<io.cucumber.core.gherkin.Pickle> filters;
    private final List<Feature> features;
    private final CucumberExecutionContext context;

    public TestNGCucumberRunner(Class<?> clazz) {
        this(clazz, key -> null);
    }

    @API(status=API.Status.STABLE, since="6.11")
    public TestNGCucumberRunner(Class<?> clazz, CucumberPropertiesProvider properties) {
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser().withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new TestNGCucumberOptionsProvider()).parse(clazz).build(propertiesFileOptions);
        RuntimeOptions testngPropertiesOptions = new CucumberPropertiesParser().parse(properties::get).build(annotationOptions);
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(testngPropertiesOptions);
        RuntimeOptions runtimeOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).enablePublishPlugin().build(environmentOptions);
        Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        UuidGeneratorServiceLoader uuidGeneratorServiceLoader = new UuidGeneratorServiceLoader(classLoader, (io.cucumber.core.eventbus.Options)runtimeOptions);
        SynchronizedEventBus bus = SynchronizedEventBus.synchronize((EventBus)new TimeServiceEventBus(Clock.systemUTC(), (Supplier)uuidGeneratorServiceLoader.loadUuidGenerator()));
        FeatureParser parser = new FeatureParser(() -> ((EventBus)bus).generateId());
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoader, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        Plugins plugins = new Plugins(new PluginFactory(), (Options)runtimeOptions);
        ExitStatus exitStatus = new ExitStatus((Options)runtimeOptions);
        plugins.addPlugin((Plugin)exitStatus);
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader(classLoader, (io.cucumber.core.backend.Options)runtimeOptions);
        ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
        BackendServiceLoader backendSupplier = new BackendServiceLoader(clazz::getClassLoader, (ObjectFactorySupplier)objectFactorySupplier);
        this.filters = new Filters((io.cucumber.core.filter.Options)runtimeOptions);
        ThreadLocalRunnerSupplier runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)runtimeOptions, (EventBus)bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier);
        this.context = new CucumberExecutionContext((EventBus)bus, exitStatus, (RunnerSupplier)runnerSupplier);
        plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)bus);
        this.features = featureSupplier.get();
        this.context.startTestRun();
        this.context.runBeforeAllHooks();
        this.features.forEach(arg_0 -> ((CucumberExecutionContext)this.context).beforeFeature(arg_0));
    }

    public void runScenario(Pickle pickle) {
        this.context.runTestCase(runner -> {
            try (TestCaseResultObserver observer = TestCaseResultObserver.observe(runner.getBus());){
                io.cucumber.core.gherkin.Pickle cucumberPickle = pickle.getPickle();
                runner.runPickle(cucumberPickle);
                observer.assertTestCasePassed();
            }
        });
    }

    public void finish() {
        try {
            this.context.runAfterAllHooks();
        }
        finally {
            this.context.finishTestRun();
        }
    }

    public Object[][] provideScenarios() {
        try {
            return (Object[][])this.features.stream().flatMap(feature -> feature.getPickles().stream().filter(this.filters).map(cucumberPickle -> new Object[]{new PickleWrapperImpl(new Pickle((io.cucumber.core.gherkin.Pickle)cucumberPickle)), new FeatureWrapperImpl((Feature)feature)})).collect(Collectors.toList()).toArray((T[])new Object[0][0]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e), null}};
        }
    }
}

