/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testng;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.testng.UndefinedStepException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.testng.SkipException;

final class TestCaseResultListener {
    private static final String SKIPPED_MESSAGE = "This scenario is skipped";
    private final EventBus bus;
    private final Map<StepLocation, List<String>> snippetsPerStep = new TreeMap<StepLocation, List<String>>();
    private final EventHandler<SnippetsSuggestedEvent> snippetsSuggestedHandler = this::snippetSuggested;
    private final boolean strict;
    private Result result;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = this::receiveResult;
    private PickleStepTestStep skippedStep;
    private final EventHandler<TestStepFinished> testStepFinished = this::testStepFinished;

    TestCaseResultListener(EventBus bus, boolean strict) {
        this.strict = strict;
        this.bus = bus;
        bus.registerHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggestedHandler);
        bus.registerHandlerFor(TestStepFinished.class, this.testStepFinished);
        bus.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    private void testStepFinished(TestStepFinished event) {
        if (!event.getResult().getStatus().is(Status.UNDEFINED)) {
            return;
        }
        TestStep testStep = event.getTestStep();
        if (!(testStep instanceof PickleStepTestStep)) {
            return;
        }
        this.skippedStep = (PickleStepTestStep)testStep;
    }

    private void receiveResult(TestCaseFinished event) {
        this.result = event.getResult();
    }

    private void snippetSuggested(SnippetsSuggestedEvent snippetsSuggestedEvent) {
        this.snippetsPerStep.putIfAbsent(new StepLocation(snippetsSuggestedEvent.getUri(), snippetsSuggestedEvent.getStepLine()), snippetsSuggestedEvent.getSnippets());
    }

    void finishExecutionUnit() {
        this.bus.removeHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggestedHandler);
        this.bus.removeHandlerFor(TestStepFinished.class, this.testStepFinished);
        this.bus.removeHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
    }

    boolean isPassed() {
        return this.result == null || this.result.getStatus().is(Status.PASSED);
    }

    Throwable getError() {
        if (this.result == null) {
            return null;
        }
        switch (this.result.getStatus()) {
            case FAILED: 
            case AMBIGUOUS: {
                return this.result.getError();
            }
            case PENDING: {
                return this.handlePendingResult();
            }
            case UNDEFINED: {
                return this.createUndefinedException();
            }
            case SKIPPED: {
                return this.handleSkippedResult();
            }
            case PASSED: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected result status: " + this.result.getStatus());
    }

    private Throwable handleSkippedResult() {
        Throwable error = this.result.getError();
        if (error == null) {
            return new SkipException(SKIPPED_MESSAGE);
        }
        if (error instanceof SkipException) {
            return error;
        }
        return new SkipException(this.result.getError().getMessage(), error);
    }

    private Throwable handlePendingResult() {
        if (this.strict) {
            return this.result.getError();
        }
        return new SkipException(this.result.getError().getMessage(), this.result.getError());
    }

    private Throwable createUndefinedException() {
        List<String> snippets = this.snippetsPerStep.remove(new StepLocation(this.skippedStep.getUri(), this.skippedStep.getStepLine()));
        return new UndefinedStepException(this.skippedStep.getStepText(), snippets, this.snippetsPerStep.values(), this.strict);
    }

    private static final class StepLocation
    implements Comparable<StepLocation> {
        private final URI uri;
        private final int line;

        private StepLocation(URI uri, int line) {
            this.uri = uri;
            this.line = line;
        }

        @Override
        public int compareTo(StepLocation o) {
            int order = this.uri.compareTo(o.uri);
            return order != 0 ? order : Integer.compare(this.line, o.line);
        }
    }
}

