/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testng;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.testng.CucumberExceptionWrapper;
import io.cucumber.testng.FeatureWrapperImpl;
import io.cucumber.testng.Pickle;
import io.cucumber.testng.PickleWrapperImpl;
import io.cucumber.testng.TestCaseResultListener;
import io.cucumber.testng.TestNGCucumberOptionsProvider;
import java.time.Clock;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class TestNGCucumberRunner {
    private static final Logger log = LoggerFactory.getLogger(TestNGCucumberRunner.class);
    private final EventBus bus;
    private final Predicate<io.cucumber.core.gherkin.Pickle> filters;
    private final ThreadLocalRunnerSupplier runnerSupplier;
    private final RuntimeOptions runtimeOptions;
    private final Plugins plugins;
    private final FeaturePathFeatureSupplier featureSupplier;

    public TestNGCucumberRunner(Class<?> clazz) {
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser().withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new TestNGCucumberOptionsProvider()).parse(clazz).build(propertiesFileOptions);
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(annotationOptions);
        this.runtimeOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).addDefaultSummaryPrinterIfAbsent().build(environmentOptions);
        this.bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        if (!this.runtimeOptions.isStrict()) {
            log.warn(() -> "By default Cucumber is running in --non-strict mode.\nThis default will change to --strict and --non-strict will be removed.\nYou can use --strict or @CucumberOptions(strict = true) to suppress this warning");
        }
        Supplier<ClassLoader> classLoader = ClassLoaders::getDefaultClassLoader;
        FeatureParser parser = new FeatureParser(() -> ((EventBus)this.bus).generateId());
        this.featureSupplier = new FeaturePathFeatureSupplier(classLoader, (io.cucumber.core.feature.Options)this.runtimeOptions, parser);
        this.plugins = new Plugins(new PluginFactory(), (Options)this.runtimeOptions);
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader((io.cucumber.core.backend.Options)this.runtimeOptions);
        ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
        BackendServiceLoader backendSupplier = new BackendServiceLoader(clazz::getClassLoader, (ObjectFactorySupplier)objectFactorySupplier);
        this.filters = new Filters((io.cucumber.core.filter.Options)this.runtimeOptions);
        ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(classLoader, (io.cucumber.core.runner.Options)this.runtimeOptions);
        this.runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)this.runtimeOptions, this.bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
    }

    public void runScenario(Pickle pickle) throws Throwable {
        Runner runner = this.runnerSupplier.get();
        TestCaseResultListener testCaseResultListener = new TestCaseResultListener(runner.getBus(), this.runtimeOptions.isStrict());
        io.cucumber.core.gherkin.Pickle cucumberPickle = pickle.getPickle();
        runner.runPickle(cucumberPickle);
        testCaseResultListener.finishExecutionUnit();
        if (!testCaseResultListener.isPassed()) {
            throw testCaseResultListener.getError();
        }
    }

    public void finish() {
        this.bus.send((Event)new TestRunFinished(this.bus.getInstant()));
    }

    public Object[][] provideScenarios() {
        try {
            return (Object[][])this.getFeatures().stream().flatMap(feature -> feature.getPickles().stream().filter(this.filters).map(cucumberPickle -> new Object[]{new PickleWrapperImpl(new Pickle((io.cucumber.core.gherkin.Pickle)cucumberPickle)), new FeatureWrapperImpl((Feature)feature)})).collect(Collectors.toList()).toArray((T[])new Object[0][0]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e), null}};
        }
    }

    private List<Feature> getFeatures() {
        this.plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)this.bus);
        List features = this.featureSupplier.get();
        this.bus.send((Event)new TestRunStarted(this.bus.getInstant()));
        for (Feature feature : features) {
            this.bus.send((Event)new TestSourceRead(this.bus.getInstant(), feature.getUri(), feature.getSource()));
        }
        return features;
    }
}

