/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.testng.CucumberExceptionWrapper;
import cucumber.api.testng.CucumberFeatureWrapperImpl;
import cucumber.api.testng.PickleEventWrapperImpl;
import cucumber.api.testng.TestCaseResultListener;
import cucumber.runner.EventBus;
import cucumber.runner.Runner;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.FeatureCompiler;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.filter.RerunFilters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import gherkin.events.PickleEvent;
import java.util.ArrayList;
import java.util.List;

public class TestNGCucumberRunner {
    private final EventBus bus;
    private final Filters filters;
    private final FeaturePathFeatureSupplier featureSupplier;
    private final ThreadLocalRunnerSupplier runnerSupplier;
    private final RuntimeOptions runtimeOptions;

    public TestNGCucumberRunner(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        this.runtimeOptions = runtimeOptionsFactory.create();
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        BackendModuleBackendSupplier backendSupplier = new BackendModuleBackendSupplier((ResourceLoader)resourceLoader, (ClassFinder)classFinder, this.runtimeOptions);
        this.bus = new TimeServiceEventBus(TimeService.SYSTEM);
        new Plugins(classLoader, new PluginFactory(), (EventPublisher)this.bus, this.runtimeOptions);
        FeatureLoader featureLoader = new FeatureLoader((ResourceLoader)resourceLoader);
        RerunFilters rerunFilters = new RerunFilters(this.runtimeOptions, featureLoader);
        this.filters = new Filters(this.runtimeOptions, rerunFilters);
        this.runnerSupplier = new ThreadLocalRunnerSupplier(this.runtimeOptions, this.bus, (BackendSupplier)backendSupplier);
        this.featureSupplier = new FeaturePathFeatureSupplier(featureLoader, this.runtimeOptions);
    }

    public void runScenario(PickleEvent pickle) throws Throwable {
        Runner runner = this.runnerSupplier.get();
        TestCaseResultListener testCaseResultListener = new TestCaseResultListener(runner.getBus(), this.runtimeOptions.isStrict());
        runner.runPickle(pickle);
        testCaseResultListener.finishExecutionUnit();
        if (!testCaseResultListener.isPassed()) {
            throw testCaseResultListener.getError();
        }
    }

    public void finish() {
        this.bus.send((Event)new TestRunFinished(this.bus.getTime()));
    }

    public Object[][] provideScenarios() {
        try {
            ArrayList<Object[]> scenarios = new ArrayList<Object[]>();
            FeatureCompiler compiler = new FeatureCompiler();
            List<CucumberFeature> features = this.getFeatures();
            for (CucumberFeature feature : features) {
                List pickles = compiler.compileFeature(feature);
                for (PickleEvent pickle : pickles) {
                    if (!this.filters.matchesFilters(pickle)) continue;
                    scenarios.add(new Object[]{new PickleEventWrapperImpl(pickle), new CucumberFeatureWrapperImpl(feature)});
                }
            }
            return (Object[][])scenarios.toArray((T[])new Object[0][]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e), null}};
        }
    }

    List<CucumberFeature> getFeatures() {
        List features = this.featureSupplier.get();
        this.bus.send((Event)new TestRunStarted(this.bus.getTime()));
        for (CucumberFeature feature : features) {
            feature.sendTestSourceRead(this.bus);
        }
        return features;
    }
}

