/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.testng.CucumberExceptionWrapper;
import cucumber.api.testng.CucumberFeatureWrapperImpl;
import cucumber.api.testng.PickleEventWrapperImpl;
import cucumber.api.testng.TestCaseResultListener;
import cucumber.api.testng.TestNGReporter;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import gherkin.events.PickleEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class TestNGCucumberRunner {
    private Runtime runtime;
    private TestNGReporter reporter;
    private RuntimeOptions runtimeOptions;
    private ResourceLoader resourceLoader;
    private TestCaseResultListener testCaseResultListener;

    public TestNGCucumberRunner(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        this.resourceLoader = new MultiLoader(classLoader);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        this.runtimeOptions = runtimeOptionsFactory.create();
        this.reporter = new TestNGReporter(new PrintStream(System.out){

            @Override
            public void close() {
            }
        });
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(this.resourceLoader, classLoader);
        this.runtime = new Runtime(this.resourceLoader, (ClassFinder)classFinder, classLoader, this.runtimeOptions);
        this.reporter.setEventPublisher((EventPublisher)this.runtime.getEventBus());
        this.testCaseResultListener = new TestCaseResultListener(this.runtimeOptions.isStrict());
        this.testCaseResultListener.setEventPublisher((EventPublisher)this.runtime.getEventBus());
    }

    public void runScenario(PickleEvent pickle) throws Throwable {
        this.testCaseResultListener.startPickle();
        this.runtime.getRunner().runPickle(pickle);
        if (!this.testCaseResultListener.isPassed()) {
            throw this.testCaseResultListener.getError();
        }
    }

    public void finish() {
        this.runtime.getEventBus().send((Event)new TestRunFinished(this.runtime.getEventBus().getTime()));
    }

    public Object[][] provideScenarios() {
        try {
            ArrayList<Object[]> scenarios = new ArrayList<Object[]>();
            List<CucumberFeature> features = this.getFeatures();
            for (CucumberFeature feature : features) {
                List pickles = this.runtime.compileFeature(feature);
                for (PickleEvent pickle : pickles) {
                    if (!this.runtime.matchesFilters(pickle)) continue;
                    scenarios.add(new Object[]{new PickleEventWrapperImpl(pickle), new CucumberFeatureWrapperImpl(feature)});
                }
            }
            return (Object[][])scenarios.toArray((T[])new Object[0][]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e), null}};
        }
    }

    List<CucumberFeature> getFeatures() {
        return this.runtimeOptions.cucumberFeatures(this.resourceLoader, this.runtime.getEventBus());
    }
}

