/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.spring.CucumberScenarioScope;
import io.cucumber.spring.CucumberTestContext;
import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;

class TestContextAdaptor {
    private static final Object monitor = new Object();
    private final TestContextManager delegate;
    private final ConfigurableApplicationContext applicationContext;
    private final Collection<Class<?>> glueClasses;
    private Object delegateTestInstance;

    TestContextAdaptor(TestContextManager delegate, Collection<Class<?>> glueClasses) {
        TestContext testContext = delegate.getTestContext();
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
        this.delegate = delegate;
        this.applicationContext = applicationContext;
        this.glueClasses = glueClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = monitor;
        synchronized (object) {
            this.registerGlueCodeScope(this.applicationContext);
            this.registerStepClassBeanDefinitions(this.applicationContext.getBeanFactory());
        }
        this.notifyContextManagerAboutBeforeTestClass();
        CucumberTestContext.getInstance().start();
        this.notifyTestContextManagerAboutBeforeTestMethod();
    }

    private void notifyTestContextManagerAboutBeforeTestMethod() {
        try {
            Class delegateTestClass = this.delegate.getTestContext().getTestClass();
            this.delegateTestInstance = this.applicationContext.getBean(delegateTestClass);
            Method dummyMethod = TestContextAdaptor.class.getMethod("cucumberDoesNotHaveASingleTestMethod", new Class[0]);
            this.delegate.beforeTestMethod(this.delegateTestInstance, dummyMethod);
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    final void registerGlueCodeScope(ConfigurableApplicationContext context) {
        while (context != null) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            Scope registeredScope = beanFactory.getRegisteredScope("cucumber-glue");
            if (registeredScope == null) {
                beanFactory.registerScope("cucumber-glue", (Scope)new CucumberScenarioScope());
            }
            context = (ConfigurableApplicationContext)context.getParent();
        }
    }

    private void notifyContextManagerAboutBeforeTestClass() {
        try {
            this.delegate.beforeTestClass();
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    final void registerStepClassBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (Class<?> glue : this.glueClasses) {
            this.registerStepClassBeanDefinition(registry, glue);
        }
    }

    private void registerStepClassBeanDefinition(BeanDefinitionRegistry registry, Class<?> glueClass) {
        String beanName = glueClass.getName();
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(glueClass).setScope("cucumber-glue").getBeanDefinition());
    }

    public final void stop() {
        if (CucumberTestContext.getInstance().isActive()) {
            if (this.delegateTestInstance != null) {
                this.notifyTestContextManagerAboutAfterTestMethod();
                this.delegateTestInstance = null;
            }
            CucumberTestContext.getInstance().stop();
        }
        this.notifyTestContextManagerAboutAfterTestClass();
    }

    private void notifyTestContextManagerAboutAfterTestClass() {
        try {
            this.delegate.afterTestClass();
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private void notifyTestContextManagerAboutAfterTestMethod() {
        try {
            Object delegateTestInstance = this.delegate.getTestContext().getTestInstance();
            Method dummyMethod = TestContextAdaptor.class.getMethod("cucumberDoesNotHaveASingleTestMethod", new Class[0]);
            this.delegate.afterTestMethod(delegateTestInstance, dummyMethod, null);
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    final <T> T getInstance(Class<T> type) {
        return (T)this.applicationContext.getBean(type);
    }

    public void cucumberDoesNotHaveASingleTestMethod() {
    }
}

