/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.spring.CucumberScenarioScope;
import io.cucumber.spring.CucumberTestContext;
import java.util.Collection;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;

abstract class TestContextAdaptor {
    private static final Object monitor = new Object();
    private final TestContextManager delegate;
    private final ConfigurableApplicationContext applicationContext;
    private final Collection<Class<?>> glueClasses;

    protected TestContextAdaptor(TestContextManager delegate, ConfigurableApplicationContext applicationContext, Collection<Class<?>> glueClasses) {
        this.delegate = delegate;
        this.applicationContext = applicationContext;
        this.glueClasses = glueClasses;
    }

    static TestContextAdaptor createTestContextManagerAdaptor(TestContextManager delegate, Collection<Class<?>> glueClasses) {
        TestContext testContext = delegate.getTestContext();
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
        return new TestContextAdaptor(delegate, applicationContext, (Collection)glueClasses){};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = monitor;
        synchronized (object) {
            this.registerGlueCodeScope(this.applicationContext);
            this.notifyContextManagerAboutTestClassStarted();
            this.registerStepClassBeanDefinitions(this.applicationContext.getBeanFactory());
        }
        CucumberTestContext.getInstance().start();
    }

    final void registerGlueCodeScope(ConfigurableApplicationContext context) {
        while (context != null) {
            context.getBeanFactory().registerScope("cucumber-glue", (Scope)new CucumberScenarioScope());
            context = (ConfigurableApplicationContext)context.getParent();
        }
    }

    private void notifyContextManagerAboutTestClassStarted() {
        try {
            this.delegate.beforeTestClass();
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    final void registerStepClassBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (Class<?> glue : this.glueClasses) {
            this.registerStepClassBeanDefinition(registry, glue);
        }
    }

    private void registerStepClassBeanDefinition(BeanDefinitionRegistry registry, Class<?> glueClass) {
        String beanName = glueClass.getName();
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(glueClass).setScope("cucumber-glue").getBeanDefinition());
    }

    public final void stop() {
        CucumberTestContext.getInstance().stop();
        try {
            this.delegate.afterTestClass();
        }
        catch (Exception e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }

    final <T> T getInstance(Class<T> type) {
        return (T)this.applicationContext.getBean(type);
    }
}

