/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.spring.TestContextAdaptor;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apiguardian.api.API;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.TestContextManager;

@API(status=API.Status.STABLE)
public final class SpringFactory
implements ObjectFactory {
    private static final String CUCUMBER_XML = "cucumber.xml";
    private final Collection<Class<?>> stepClasses = new HashSet();
    private Class<?> stepClassWithSpringContext = null;
    private TestContextAdaptor testContextAdaptor;

    private static void checkNoComponentAnnotations(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            if (!SpringFactory.hasComponentAnnotation(annotation)) continue;
            throw new CucumberBackendException(String.format("Glue class %1$s was annotated with @%2$s; marking it as a candidate for auto-detection by Spring. Glue classes are detected and registered by Cucumber. Auto-detection of glue classes by spring may lead to duplicate bean definitions. Please remove the @%2$s annotation", type.getName(), annotation.annotationType().getSimpleName()));
        }
    }

    private static boolean hasComponentAnnotation(Annotation annotation) {
        return SpringFactory.hasAnnotation(annotation, Collections.singleton(Component.class));
    }

    private static boolean hasAnnotation(Annotation annotation, Collection<Class<? extends Annotation>> desired) {
        HashSet<Class> seen = new HashSet<Class>();
        ArrayDeque<Class<? extends Annotation>> toCheck = new ArrayDeque<Class<? extends Annotation>>();
        toCheck.add(annotation.annotationType());
        while (!toCheck.isEmpty()) {
            Class annotationType = (Class)toCheck.pop();
            if (desired.contains(annotationType)) {
                return true;
            }
            seen.add(annotationType);
            for (Annotation annotationTypesAnnotations : annotationType.getAnnotations()) {
                if (seen.contains(annotationTypesAnnotations.annotationType())) continue;
                toCheck.add(annotationTypesAnnotations.annotationType());
            }
        }
        return false;
    }

    private static boolean dependsOnSpringContext(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            if (!SpringFactory.annotatedWithSupportedSpringRootTestAnnotations(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean annotatedWithSupportedSpringRootTestAnnotations(Annotation type) {
        return SpringFactory.hasAnnotation(type, Arrays.asList(ContextConfiguration.class, ContextHierarchy.class, BootstrapWith.class));
    }

    public boolean addClass(Class<?> stepClass) {
        if (!this.stepClasses.contains(stepClass)) {
            SpringFactory.checkNoComponentAnnotations(stepClass);
            if (SpringFactory.dependsOnSpringContext(stepClass)) {
                if (this.stepClassWithSpringContext != null) {
                    throw new CucumberBackendException(String.format("Glue class %1$s and %2$s both attempt to configure the spring context. Please ensure only one glue class configures the spring context", stepClass, this.stepClassWithSpringContext));
                }
                this.stepClassWithSpringContext = stepClass;
            }
            this.stepClasses.add(stepClass);
        }
        return true;
    }

    public void start() {
        if (this.stepClassWithSpringContext != null) {
            TestContextManager testContextManager = new TestContextManager(this.stepClassWithSpringContext);
            this.testContextAdaptor = TestContextAdaptor.createTestContextManagerAdaptor(testContextManager, this.stepClasses);
        } else if (this.getClass().getClassLoader().getResource(CUCUMBER_XML) == null) {
            this.testContextAdaptor = TestContextAdaptor.createGenericApplicationContextAdaptor(this.stepClasses);
        } else if (this.testContextAdaptor == null) {
            String[] configLocations = new String[]{CUCUMBER_XML};
            this.testContextAdaptor = TestContextAdaptor.createClassPathXmlApplicationContextAdaptor(configLocations, this.stepClasses);
        }
        this.testContextAdaptor.start();
    }

    public void stop() {
        if (this.testContextAdaptor != null) {
            this.testContextAdaptor.stop();
        }
    }

    public <T> T getInstance(Class<T> type) {
        try {
            return this.testContextAdaptor.getInstance(type);
        }
        catch (BeansException e) {
            throw new CucumberBackendException(e.getMessage(), (Throwable)e);
        }
    }
}

