/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.openejb;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.embeddable.EJBContainer;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class OpenEJBObjectFactory
implements ObjectFactory {
    private final List<String> classes = new ArrayList<String>();
    private final Map<Class<?>, Object> instances = new HashMap();
    private EJBContainer container;

    public void start() {
        StringBuilder callers = new StringBuilder();
        Iterator<String> it = this.classes.iterator();
        while (it.hasNext()) {
            callers.append(it.next());
            if (!it.hasNext()) continue;
            callers.append(",");
        }
        Properties properties = new Properties();
        properties.setProperty("openejb.additionnal.callers", callers.toString());
        this.container = EJBContainer.createEJBContainer((Map)properties);
    }

    public void stop() {
        this.container.close();
        this.instances.clear();
    }

    public boolean addClass(Class<?> clazz) {
        this.classes.add(clazz.getName());
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        T object;
        if (this.instances.containsKey(type)) {
            return type.cast(this.instances.get(type));
        }
        try {
            object = type.newInstance();
            this.container.getContext().bind("inject", object);
        }
        catch (Exception e) {
            throw new CucumberBackendException("can't create " + type.getName(), (Throwable)e);
        }
        this.instances.put(type, object);
        return object;
    }
}

