/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.CucumberPickle;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.junit.FileNameCompatibleNames;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitReporter;
import io.cucumber.plugin.event.CucumberStep;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

final class PickleRunners {
    PickleRunners() {
    }

    static PickleRunner withStepDescriptions(RunnerSupplier runnerSupplier, CucumberPickle pickle, JUnitOptions options) {
        try {
            return new WithStepDescriptions(runnerSupplier, pickle, options);
        }
        catch (InitializationError e) {
            throw new CucumberException("Failed to create scenario runner", (Throwable)e);
        }
    }

    static PickleRunner withNoStepDescriptions(String featureName, RunnerSupplier runnerSupplier, CucumberPickle pickle, JUnitOptions jUnitOptions) {
        return new NoStepDescriptions(featureName, runnerSupplier, pickle, jUnitOptions);
    }

    private static final class PickleStepId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;
        private final int pickleLine;
        private int pickleStepLine;

        PickleStepId(CucumberPickle pickle, CucumberStep step) {
            this.uri = pickle.getUri();
            this.pickleLine = pickle.getLocation().getLine();
            this.pickleStepLine = step.getStepLine();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickleStepId that = (PickleStepId)o;
            return this.pickleLine == that.pickleLine && this.pickleStepLine == that.pickleStepLine && this.uri.equals(that.uri);
        }

        public int hashCode() {
            int result = this.pickleLine;
            result = 31 * result + this.uri.hashCode();
            result = 31 * result + this.pickleStepLine;
            return result;
        }

        public String toString() {
            return this.uri + ":" + this.pickleLine + ":" + this.pickleStepLine;
        }
    }

    static final class PickleId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;
        private final int pickleLine;

        PickleId(URI uri, int pickleLine) {
            this.uri = uri;
            this.pickleLine = pickleLine;
        }

        PickleId(CucumberPickle pickle) {
            this(pickle.getUri(), pickle.getLocation().getLine());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickleId that = (PickleId)o;
            return this.pickleLine == that.pickleLine && this.uri.equals(that.uri);
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + this.pickleLine;
            return result;
        }

        public String toString() {
            return this.uri + ":" + this.pickleLine;
        }
    }

    static final class NoStepDescriptions
    implements PickleRunner {
        private final String featureName;
        private final RunnerSupplier runnerSupplier;
        private final CucumberPickle pickle;
        private final JUnitOptions jUnitOptions;
        private Description description;

        NoStepDescriptions(String featureName, RunnerSupplier runnerSupplier, CucumberPickle pickle, JUnitOptions jUnitOptions) {
            this.featureName = featureName;
            this.runnerSupplier = runnerSupplier;
            this.pickle = pickle;
            this.jUnitOptions = jUnitOptions;
        }

        @Override
        public Description getDescription() {
            if (this.description == null) {
                String className = FileNameCompatibleNames.createName(this.featureName, this.jUnitOptions.filenameCompatibleNames());
                String name = FileNameCompatibleNames.createName(this.pickle.getName(), this.jUnitOptions.filenameCompatibleNames());
                this.description = Description.createTestDescription((String)className, (String)name, (Serializable)new PickleId(this.pickle));
            }
            return this.description;
        }

        @Override
        public Description describeChild(CucumberStep step) {
            throw new UnsupportedOperationException("This pickle runner does not wish to describe its children");
        }

        @Override
        public void run(RunNotifier notifier) {
            Runner runner = this.runnerSupplier.get();
            JUnitReporter jUnitReporter = new JUnitReporter(runner.getBus(), this.jUnitOptions);
            jUnitReporter.startExecutionUnit(this, notifier);
            runner.runPickle(this.pickle);
            jUnitReporter.finishExecutionUnit();
        }
    }

    static class WithStepDescriptions
    extends ParentRunner<CucumberStep>
    implements PickleRunner {
        private final RunnerSupplier runnerSupplier;
        private final CucumberPickle pickle;
        private final JUnitOptions jUnitOptions;
        private final Map<CucumberStep, Description> stepDescriptions = new HashMap<CucumberStep, Description>();
        private Description description;

        WithStepDescriptions(RunnerSupplier runnerSupplier, CucumberPickle pickle, JUnitOptions jUnitOptions) throws InitializationError {
            super(null);
            this.runnerSupplier = runnerSupplier;
            this.pickle = pickle;
            this.jUnitOptions = jUnitOptions;
        }

        protected List<CucumberStep> getChildren() {
            return new ArrayList<CucumberStep>(this.pickle.getSteps());
        }

        protected String getName() {
            return FileNameCompatibleNames.createName(this.pickle.getName(), this.jUnitOptions.filenameCompatibleNames());
        }

        @Override
        public Description getDescription() {
            if (this.description == null) {
                this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)new PickleId(this.pickle), (Annotation[])new Annotation[0]);
                this.getChildren().forEach(step -> this.description.addChild(this.describeChild((CucumberStep)step)));
            }
            return this.description;
        }

        @Override
        public Description describeChild(CucumberStep step) {
            Description description = this.stepDescriptions.get(step);
            if (description == null) {
                String testName = FileNameCompatibleNames.createName(step.getText(), this.jUnitOptions.filenameCompatibleNames());
                description = Description.createTestDescription((String)this.getName(), (String)testName, (Serializable)new PickleStepId(this.pickle, step));
                this.stepDescriptions.put(step, description);
            }
            return description;
        }

        @Override
        public void run(RunNotifier notifier) {
            Runner runner = this.runnerSupplier.get();
            JUnitReporter jUnitReporter = new JUnitReporter(runner.getBus(), this.jUnitOptions);
            jUnitReporter.startExecutionUnit(this, notifier);
            runner.runPickle(this.pickle);
            jUnitReporter.finishExecutionUnit();
        }

        protected void runChild(CucumberStep step, RunNotifier notifier) {
            throw new UnsupportedOperationException();
        }
    }

    static interface PickleRunner {
        public void run(RunNotifier var1);

        public Description getDescription();

        public Description describeChild(CucumberStep var1);
    }
}

