/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.resource.Resource;
import io.cucumber.junit.platform.engine.FeatureParserWithIssueReporting;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class FeatureParserWithCaching {
    private final Map<URI, Optional<Feature>> cache = new HashMap<URI, Optional<Feature>>();
    private final FeatureParserWithIssueReporting delegate;

    FeatureParserWithCaching(FeatureParserWithIssueReporting delegate) {
        this.delegate = delegate;
    }

    Optional<Feature> parseResource(Resource resource) {
        return this.cache.computeIfAbsent(resource.getUri(), uri -> this.delegate.parseResource(resource));
    }

    Optional<Feature> parseResource(Path resource) {
        return this.parseResource(new PathAdapter(resource));
    }

    Optional<Feature> parseResource(org.junit.platform.commons.support.Resource resource) {
        return this.parseResource(new ResourceAdapter(resource));
    }

    private static class PathAdapter
    implements Resource {
        private final Path resource;

        public PathAdapter(Path resource) {
            this.resource = resource;
        }

        public URI getUri() {
            return this.resource.toUri();
        }

        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.resource, new OpenOption[0]);
        }
    }

    private static class ResourceAdapter
    implements Resource {
        private final org.junit.platform.commons.support.Resource resource;

        public ResourceAdapter(org.junit.platform.commons.support.Resource resource) {
            this.resource = resource;
        }

        public URI getUri() {
            String name = this.resource.getName();
            try {
                return new URI("classpath", name, null);
            }
            catch (URISyntaxException e) {
                String message = String.format("Could not create classpath uri for resource '%s'", name);
                throw new CucumberException(message, (Throwable)e);
            }
        }

        public InputStream getInputStream() throws IOException {
            return this.resource.getInputStream();
        }
    }
}

