/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberConfiguration;
import io.cucumber.junit.platform.engine.CucumberEngineDescriptor;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.DiscoverySelectorResolver;
import io.cucumber.junit.platform.engine.FeaturesPropertyResolver;
import org.apiguardian.api.API;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.hierarchical.ForkJoinPoolHierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;

@API(status=API.Status.STABLE)
public final class CucumberTestEngine
extends HierarchicalTestEngine<CucumberEngineExecutionContext> {
    public String getId() {
        return "cucumber";
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        TestSource testSource = CucumberTestEngine.createEngineTestSource(discoveryRequest);
        CucumberConfiguration configuration = new CucumberConfiguration(discoveryRequest.getConfigurationParameters());
        CucumberEngineDescriptor engineDescriptor = new CucumberEngineDescriptor(uniqueId, configuration, testSource);
        DiscoveryIssueReporter issueReporter = DiscoveryIssueReporter.deduplicating((DiscoveryIssueReporter)DiscoveryIssueReporter.forwarding((EngineDiscoveryListener)discoveryRequest.getDiscoveryListener(), (UniqueId)engineDescriptor.getUniqueId()));
        FeaturesPropertyResolver resolver = new FeaturesPropertyResolver(new DiscoverySelectorResolver());
        resolver.resolveSelectors(discoveryRequest, engineDescriptor, issueReporter);
        return engineDescriptor;
    }

    private static TestSource createEngineTestSource(EngineDiscoveryRequest discoveryRequest) {
        ConfigurationParameters configuration = discoveryRequest.getConfigurationParameters();
        if (configuration.get("cucumber.features").isPresent()) {
            return ClassSource.from(CucumberTestEngine.class);
        }
        return null;
    }

    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request) {
        CucumberConfiguration configuration = this.getCucumberConfiguration(request);
        if (configuration.isParallelExecutionEnabled()) {
            return new ForkJoinPoolHierarchicalTestExecutorService((ConfigurationParameters)new PrefixedConfigurationParameters(request.getConfigurationParameters(), "cucumber.execution.parallel.config."));
        }
        return super.createExecutorService(request);
    }

    protected CucumberEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        CucumberConfiguration configuration = this.getCucumberConfiguration(request);
        return new CucumberEngineExecutionContext(configuration);
    }

    private CucumberConfiguration getCucumberConfiguration(ExecutionRequest request) {
        CucumberEngineDescriptor engineDescriptor = (CucumberEngineDescriptor)request.getRootTestDescriptor();
        return engineDescriptor.getConfiguration();
    }
}

