/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberEngineDescriptor;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.DiscoverySelectorResolver;
import org.apiguardian.api.API;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.ForkJoinPoolHierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestEngine;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;

@API(status=API.Status.STABLE)
public final class CucumberTestEngine
extends HierarchicalTestEngine<CucumberEngineExecutionContext> {
    public String getId() {
        return "cucumber";
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        TestSource testSource = CucumberTestEngine.createEngineTestSource(discoveryRequest);
        CucumberEngineDescriptor engineDescriptor = new CucumberEngineDescriptor(uniqueId, testSource);
        new DiscoverySelectorResolver().resolveSelectors(discoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    private static TestSource createEngineTestSource(EngineDiscoveryRequest discoveryRequest) {
        ConfigurationParameters configuration = discoveryRequest.getConfigurationParameters();
        if (configuration.get("cucumber.features").isPresent()) {
            return ClassSource.from(CucumberTestEngine.class);
        }
        return null;
    }

    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request) {
        ConfigurationParameters config = request.getConfigurationParameters();
        if (config.getBoolean("cucumber.execution.parallel.enabled").orElse(false).booleanValue()) {
            return new ForkJoinPoolHierarchicalTestExecutorService((ConfigurationParameters)new PrefixedConfigurationParameters(config, "cucumber.execution.parallel.config."));
        }
        return super.createExecutorService(request);
    }

    protected CucumberEngineExecutionContext createExecutionContext(ExecutionRequest request) {
        return new CucumberEngineExecutionContext(request.getConfigurationParameters());
    }
}

