/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.FeatureDescriptor;
import java.util.Optional;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

class CucumberEngineDescriptor
extends EngineDescriptor
implements Node<CucumberEngineExecutionContext> {
    CucumberEngineDescriptor(UniqueId uniqueId) {
        super(uniqueId, "Cucumber");
    }

    public CucumberEngineExecutionContext before(CucumberEngineExecutionContext context) {
        context.emitMetaAndStartTestRun();
        return context;
    }

    public void after(CucumberEngineExecutionContext context) {
        context.finishTestRun();
    }

    void mergeFeature(FeatureDescriptor descriptor) {
        CucumberEngineDescriptor.recursivelyMerge((TestDescriptor)descriptor, (TestDescriptor)this);
    }

    private static void recursivelyMerge(TestDescriptor descriptor, TestDescriptor parent) {
        Optional byUniqueId = parent.findByUniqueId(descriptor.getUniqueId());
        if (!byUniqueId.isPresent()) {
            parent.addChild(descriptor);
        } else {
            byUniqueId.ifPresent(existingParent -> descriptor.getChildren().forEach(child -> CucumberEngineDescriptor.recursivelyMerge(child, existingParent)));
        }
    }
}

