/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.tagexpressions.Expression;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.hierarchical.Node;

class PickleDescriptor
extends AbstractTestDescriptor
implements Node<CucumberEngineExecutionContext> {
    private final Pickle pickleEvent;

    PickleDescriptor(UniqueId uniqueId, String name, TestSource source, Pickle pickleEvent) {
        super(uniqueId, name, source);
        this.pickleEvent = pickleEvent;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public CucumberEngineExecutionContext execute(CucumberEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        context.runTestCase(this.pickleEvent);
        return context;
    }

    public Node.SkipResult shouldBeSkipped(CucumberEngineExecutionContext context) {
        List tags = this.pickleEvent.getTags();
        Expression expression = context.getOptions().tagFilter();
        if (expression.evaluate(tags)) {
            return Node.SkipResult.doNotSkip();
        }
        return Node.SkipResult.skip((String)("'cucumber.filter.tags=" + expression + "' did not match this scenario"));
    }

    public Set<TestTag> getTags() {
        return this.pickleEvent.getTags().stream().map(tag -> tag.substring(1)).filter(TestTag::isValid).map(TestTag::create).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    Optional<String> getPackage() {
        return this.getSource().filter(ClasspathResourceSource.class::isInstance).map(ClasspathResourceSource.class::cast).map(ClasspathResourceSource::getClasspathResourceName).map(ClasspathSupport::packageNameOfResource);
    }
}

