/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.junit.platform.engine.UndefinedStepException;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.platform.commons.util.ExceptionUtils;
import org.opentest4j.TestAbortedException;

class TestCaseResultObserver
implements AutoCloseable {
    private final EventPublisher bus;
    private final Map<StepLocation, List<String>> snippetsPerStep = new TreeMap<StepLocation, List<String>>();
    private final List<UndefinedStepException.Suggestion> suggestions = new ArrayList<UndefinedStepException.Suggestion>();
    private final EventHandler<SnippetsSuggestedEvent> snippetsSuggested = this::handleSnippetSuggestedEvent;
    private final EventHandler<TestStepFinished> testStepFinished = this::handleTestStepFinished;
    private Result result;
    private final EventHandler<TestCaseFinished> testCaseFinished = this::handleTestCaseFinished;

    private TestCaseResultObserver(EventPublisher bus) {
        this.bus = bus;
        bus.registerHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggested);
        bus.registerHandlerFor(TestStepFinished.class, this.testStepFinished);
        bus.registerHandlerFor(TestCaseFinished.class, this.testCaseFinished);
    }

    static TestCaseResultObserver observe(EventBus bus) {
        return new TestCaseResultObserver((EventPublisher)bus);
    }

    @Override
    public void close() {
        this.bus.removeHandlerFor(SnippetsSuggestedEvent.class, this.snippetsSuggested);
        this.bus.removeHandlerFor(TestStepFinished.class, this.testStepFinished);
        this.bus.removeHandlerFor(TestCaseFinished.class, this.testCaseFinished);
    }

    private void handleSnippetSuggestedEvent(SnippetsSuggestedEvent event) {
        this.snippetsPerStep.putIfAbsent(new StepLocation(event.getUri(), event.getStepLine()), event.getSnippets());
    }

    private void handleTestStepFinished(TestStepFinished event) {
        Result result = event.getResult();
        Status status = result.getStatus();
        if (!status.is(Status.UNDEFINED)) {
            return;
        }
        TestStep testStep = event.getTestStep();
        if (!(testStep instanceof PickleStepTestStep)) {
            return;
        }
        PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
        String stepText = pickleStepTestStep.getStepText();
        List<String> snippets = this.snippetsPerStep.get(new StepLocation(pickleStepTestStep.getUri(), pickleStepTestStep.getStepLine()));
        this.suggestions.add(new UndefinedStepException.Suggestion(stepText, snippets));
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        this.result = event.getResult();
    }

    void assertTestCasePassed() {
        Status status = this.result.getStatus();
        if (status.is(Status.PASSED)) {
            return;
        }
        Throwable error = this.result.getError();
        if (status.is(Status.SKIPPED) && error == null) {
            throw new TestAbortedException();
        }
        if (status.is(Status.UNDEFINED)) {
            if (this.suggestions.isEmpty()) {
                return;
            }
            throw new UndefinedStepException(this.suggestions);
        }
        throw ExceptionUtils.throwAsUncheckedException((Throwable)error);
    }

    private static final class StepLocation
    implements Comparable<StepLocation> {
        private final URI uri;
        private final int line;

        private StepLocation(URI uri, int line) {
            this.uri = uri;
            this.line = line;
        }

        @Override
        public int compareTo(StepLocation o) {
            int order = this.uri.compareTo(o.uri);
            return order != 0 ? order : Integer.compare(this.line, o.line);
        }
    }
}

