/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.datatable.DataTable;
import io.cucumber.java8.AbstractGlueDefinition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class AbstractDatatableElementTransformerDefinition
extends AbstractGlueDefinition {
    private final String[] emptyPatterns;

    AbstractDatatableElementTransformerDefinition(Object body, StackTraceElement location, String[] emptyPatterns) {
        super(body, location);
        this.emptyPatterns = emptyPatterns;
    }

    DataTable replaceEmptyPatternsWithEmptyString(DataTable table) {
        List rawWithEmptyStrings = table.cells().stream().map(this::replaceEmptyPatternsWithEmptyString).collect(Collectors.toList());
        return DataTable.create(rawWithEmptyStrings, (DataTable.TableConverter)table.getTableConverter());
    }

    List<String> replaceEmptyPatternsWithEmptyString(List<String> row) {
        return row.stream().map(this::replaceEmptyPatternsWithEmptyString).collect(Collectors.toList());
    }

    String replaceEmptyPatternsWithEmptyString(String t) {
        for (String emptyPattern : this.emptyPatterns) {
            if (!emptyPattern.equals(t)) continue;
            return "";
        }
        return t;
    }

    Map<String, String> replaceEmptyPatternsWithEmptyString(Map<String, String> fromValue) {
        LinkedHashMap<String, String> replacement = new LinkedHashMap<String, String>();
        fromValue.forEach((key, value) -> {
            String potentiallyEmptyKey = this.replaceEmptyPatternsWithEmptyString((String)key);
            String potentiallyEmptyValue = this.replaceEmptyPatternsWithEmptyString((String)value);
            if (replacement.containsKey(potentiallyEmptyKey)) {
                throw this.createDuplicateKeyAfterReplacement(fromValue);
            }
            replacement.put(potentiallyEmptyKey, potentiallyEmptyValue);
        });
        return replacement;
    }

    private IllegalArgumentException createDuplicateKeyAfterReplacement(Map<String, String> fromValue) {
        ArrayList<String> conflict = new ArrayList<String>(2);
        for (String emptyPattern : this.emptyPatterns) {
            if (!fromValue.containsKey(emptyPattern)) continue;
            conflict.add(emptyPattern);
        }
        String msg = "After replacing %s and %s with empty strings the datatable entry contains duplicate keys: %s";
        return new IllegalArgumentException(String.format(msg, conflict.get(0), conflict.get(1), fromValue));
    }
}

