/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.jakarta.cdi;

import io.cucumber.core.backend.ObjectFactory;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Unmanaged;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class CdiJakartaFactory
implements ObjectFactory {
    private final Map<Class<?>, Unmanaged.UnmanagedInstance<?>> standaloneInstances = new HashMap();
    private SeContainerInitializer initializer;
    private SeContainer container;

    public void start() {
        this.container = this.getInitializer().initialize();
    }

    public void stop() {
        if (this.container != null) {
            this.container.close();
            this.container = null;
            this.initializer = null;
        }
        for (Unmanaged.UnmanagedInstance<?> unmanaged : this.standaloneInstances.values()) {
            unmanaged.preDestroy();
            unmanaged.dispose();
        }
        this.standaloneInstances.clear();
    }

    private SeContainerInitializer getInitializer() {
        if (this.initializer == null) {
            this.initializer = SeContainerInitializer.newInstance();
        }
        return this.initializer;
    }

    public boolean addClass(Class<?> clazz) {
        this.getInitializer().addBeanClasses(new Class[]{clazz});
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        Unmanaged.UnmanagedInstance<?> instance = this.standaloneInstances.get(type);
        if (instance != null) {
            return type.cast(instance);
        }
        Instance selected = this.container.select(type, new Annotation[0]);
        if (selected.isUnsatisfied()) {
            BeanManager beanManager = this.container.getBeanManager();
            Unmanaged unmanaged = new Unmanaged(beanManager, type);
            Unmanaged.UnmanagedInstance value = unmanaged.newInstance();
            value.produce();
            value.inject();
            value.postConstruct();
            this.standaloneInstances.put(type, value);
            return (T)value.get();
        }
        return (T)selected.get();
    }
}

