/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.GherkinMessagesRule;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenario;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenarioOutline;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class GherkinMessagesFeature
implements Feature {
    private final URI uri;
    private final List<Pickle> pickles;
    private final List<Messages.Envelope> envelopes;
    private final Messages.GherkinDocument gherkinDocument;
    private final String gherkinSource;
    private final List<Node> children;

    GherkinMessagesFeature(Messages.GherkinDocument gherkinDocument, URI uri, String gherkinSource, List<Pickle> pickles, List<Messages.Envelope> envelopes) {
        this.gherkinDocument = gherkinDocument;
        this.uri = uri;
        this.gherkinSource = gherkinSource;
        this.pickles = pickles;
        this.envelopes = envelopes;
        this.children = gherkinDocument.getFeature().getChildrenList().stream().filter(featureChild -> featureChild.hasRule() || featureChild.hasScenario()).map(featureChild -> {
            if (featureChild.hasRule()) {
                return new GherkinMessagesRule(featureChild.getRule());
            }
            Messages.GherkinDocument.Feature.Scenario scenario = featureChild.getScenario();
            if (scenario.getExamplesCount() > 0) {
                return new GherkinMessagesScenarioOutline(scenario);
            }
            return new GherkinMessagesScenario(scenario);
        }).collect(Collectors.toList());
    }

    public Collection<Node> elements() {
        return this.children;
    }

    public Optional<String> getKeyword() {
        return Optional.of(this.gherkinDocument.getFeature().getKeyword());
    }

    public Location getLocation() {
        return GherkinMessagesLocation.from(this.gherkinDocument.getFeature().getLocation());
    }

    public Pickle getPickleAt(Node node) {
        Location location = node.getLocation();
        return this.pickles.stream().filter(pickle -> pickle.getLocation().equals((Object)location)).findFirst().orElseThrow(() -> new NoSuchElementException("No pickle in " + this.uri + " at " + location));
    }

    public List<Pickle> getPickles() {
        return this.pickles;
    }

    public Optional<String> getName() {
        String name = this.gherkinDocument.getFeature().getName();
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSource() {
        return this.gherkinSource;
    }

    public Iterable<?> getParseEvents() {
        return this.envelopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinMessagesFeature that = (GherkinMessagesFeature)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }
}

