/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.CucumberQuery;
import io.cucumber.core.gherkin.messages.GherkinMessagesFeature;
import io.cucumber.core.gherkin.messages.GherkinMessagesPickle;
import io.cucumber.core.gherkin.messages.internal.gherkin.Gherkin;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialectProvider;
import io.cucumber.messages.Messages;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GherkinMessagesFeatureParser
implements FeatureParser {
    public Optional<Feature> parse(URI path, String source, Supplier<UUID> idGenerator) {
        List<Messages.Envelope> sources = Collections.singletonList(Gherkin.makeSourceEnvelope(source, path.toString()));
        List<Messages.Envelope> envelopes = Gherkin.fromSources(sources, true, true, true, () -> ((UUID)idGenerator.get()).toString()).collect(Collectors.toList());
        Messages.GherkinDocument gherkinDocument = envelopes.stream().filter(Messages.Envelope::hasGherkinDocument).map(Messages.Envelope::getGherkinDocument).findFirst().orElse(null);
        if (gherkinDocument == null || !gherkinDocument.hasFeature()) {
            List errors = envelopes.stream().filter(Messages.Envelope::hasParseError).map(Messages.Envelope::getParseError).map(Messages.ParseError::getMessage).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                throw new FeatureParserException("Failed to parse resource at: " + path.toString() + "\n" + String.join((CharSequence)"\n", errors));
            }
            return Optional.empty();
        }
        CucumberQuery cucumberQuery = new CucumberQuery();
        cucumberQuery.update(gherkinDocument);
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        String language = gherkinDocument.getFeature().getLanguage();
        GherkinDialect dialect = dialectProvider.getDialect(language, null);
        List pickleMessages = envelopes.stream().filter(Messages.Envelope::hasPickle).map(Messages.Envelope::getPickle).collect(Collectors.toList());
        if (pickleMessages.isEmpty()) {
            return Optional.empty();
        }
        List<Pickle> pickles = pickleMessages.stream().map(pickle -> new GherkinMessagesPickle((Messages.Pickle)pickle, path, dialect, cucumberQuery)).collect(Collectors.toList());
        GherkinMessagesFeature feature = new GherkinMessagesFeature(gherkinDocument, path, source, pickles, envelopes);
        return Optional.of(feature);
    }

    public String version() {
        return "8";
    }
}

