/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages.internal.gherkin;

import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinLineSpan;
import io.cucumber.core.gherkin.messages.internal.gherkin.IGherkinLine;
import io.cucumber.core.gherkin.messages.internal.gherkin.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Scanner;

public class GherkinLine
implements IGherkinLine {
    private static final int OFFSET = 1;
    private final String lineText;
    private final String trimmedLineText;
    private final int indent;

    public GherkinLine(String lineText) {
        this.lineText = lineText;
        this.trimmedLineText = StringUtils.trim(lineText);
        this.indent = StringUtils.symbolCount(lineText) - StringUtils.symbolCount(StringUtils.ltrim(lineText));
    }

    @Override
    public int indent() {
        return this.indent;
    }

    @Override
    public void detach() {
    }

    @Override
    public String getLineText(int indentToRemove) {
        if (indentToRemove < 0 || indentToRemove > this.indent()) {
            return this.trimmedLineText;
        }
        return this.lineText.substring(indentToRemove);
    }

    @Override
    public boolean isEmpty() {
        return this.trimmedLineText.length() == 0;
    }

    @Override
    public boolean startsWith(String prefix) {
        return this.trimmedLineText.startsWith(prefix);
    }

    @Override
    public String getRestTrimmed(int length) {
        return this.trimmedLineText.substring(length).trim();
    }

    @Override
    public List<GherkinLineSpan> getTags() {
        return this.getSpans("\\s+");
    }

    @Override
    public List<GherkinLineSpan> getTableCells() {
        ArrayList<GherkinLineSpan> lineSpans = new ArrayList<GherkinLineSpan>();
        StringBuilder cellBuilder = new StringBuilder();
        boolean beforeFirst = true;
        int col = 0;
        int cellStart = 0;
        boolean escape = false;
        PrimitiveIterator.OfInt iterator = this.lineText.codePoints().iterator();
        while (iterator.hasNext()) {
            int c = iterator.next();
            if (escape) {
                switch (c) {
                    case 110: {
                        cellBuilder.append('\n');
                        break;
                    }
                    case 92: {
                        cellBuilder.append('\\');
                        break;
                    }
                    case 124: {
                        cellBuilder.append('|');
                        break;
                    }
                    default: {
                        cellBuilder.append("\\");
                        cellBuilder.appendCodePoint(c);
                    }
                }
                escape = false;
            } else if (c == 92) {
                escape = true;
            } else if (c == 124) {
                if (beforeFirst) {
                    beforeFirst = false;
                } else {
                    String cell = cellBuilder.toString();
                    String leftTrimmedCell = StringUtils.ltrim(cell);
                    int cellIndent = StringUtils.symbolCount(cell) - StringUtils.symbolCount(leftTrimmedCell);
                    lineSpans.add(new GherkinLineSpan(cellStart + cellIndent + 1, StringUtils.rtrim(leftTrimmedCell)));
                }
                cellBuilder = new StringBuilder();
                cellStart = col + 1;
            } else {
                cellBuilder.appendCodePoint(c);
            }
            ++col;
        }
        return lineSpans;
    }

    @Override
    public boolean startsWithTitleKeyword(String text) {
        int textLength = text.length();
        return this.trimmedLineText.length() > textLength && this.trimmedLineText.startsWith(text) && this.trimmedLineText.substring(textLength, textLength + ":".length()).equals(":");
    }

    private List<GherkinLineSpan> getSpans(String delimiter) {
        ArrayList<GherkinLineSpan> lineSpans = new ArrayList<GherkinLineSpan>();
        Scanner scanner = new Scanner(this.trimmedLineText).useDelimiter(delimiter);
        while (scanner.hasNext()) {
            String cell = scanner.next();
            String leftTrimmedCell = StringUtils.ltrim(cell);
            int cellIndent = StringUtils.symbolCount(cell) - StringUtils.symbolCount(leftTrimmedCell);
            String trimmedCell = StringUtils.rtrim(leftTrimmedCell);
            int scannerStart = scanner.match().start();
            int symbolLength = this.trimmedLineText.codePointCount(0, scannerStart);
            int column = 1 + this.indent() + symbolLength + cellIndent;
            lineSpans.add(new GherkinLineSpan(column, trimmedCell));
        }
        return lineSpans;
    }
}

