/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Argument;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import io.cucumber.core.gherkin.messages.GherkinMessagesDataTableArgument;
import io.cucumber.core.gherkin.messages.GherkinMessagesDocStringArgument;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.messages.Messages;

final class GherkinMessagesStep
implements Step {
    private final Messages.Pickle.PickleStep pickleStep;
    private final Argument argument;
    private final String keyWord;
    private final StepType stepType;
    private final String previousGwtKeyWord;
    private final int stepLine;

    GherkinMessagesStep(Messages.Pickle.PickleStep pickleStep, GherkinDialect dialect, String previousGwtKeyWord, int stepLine, String keyword) {
        this.pickleStep = pickleStep;
        this.argument = GherkinMessagesStep.extractArgument(pickleStep, stepLine);
        this.keyWord = keyword;
        this.stepType = GherkinMessagesStep.extractKeyWordType(this.keyWord, dialect);
        this.previousGwtKeyWord = previousGwtKeyWord;
        this.stepLine = stepLine;
    }

    private static StepType extractKeyWordType(String keyWord, GherkinDialect dialect) {
        if (StepType.isAstrix((String)keyWord)) {
            return StepType.OTHER;
        }
        if (dialect.getGivenKeywords().contains(keyWord)) {
            return StepType.GIVEN;
        }
        if (dialect.getWhenKeywords().contains(keyWord)) {
            return StepType.WHEN;
        }
        if (dialect.getThenKeywords().contains(keyWord)) {
            return StepType.THEN;
        }
        if (dialect.getAndKeywords().contains(keyWord)) {
            return StepType.AND;
        }
        if (dialect.getButKeywords().contains(keyWord)) {
            return StepType.BUT;
        }
        throw new IllegalStateException("Keyword " + keyWord + " was neither given, when, then, and, but nor *");
    }

    private static Argument extractArgument(Messages.Pickle.PickleStep pickleStep, int stepLine) {
        Messages.PickleStepArgument argument = pickleStep.getArgument();
        if (argument.hasDocString()) {
            Messages.PickleStepArgument.PickleDocString docString = argument.getDocString();
            return new GherkinMessagesDocStringArgument(docString, stepLine + 1);
        }
        if (argument.hasDataTable()) {
            Messages.PickleStepArgument.PickleTable table = argument.getDataTable();
            return new GherkinMessagesDataTableArgument(table, stepLine + 1);
        }
        return null;
    }

    public int getLine() {
        return this.stepLine;
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public StepType getType() {
        return this.stepType;
    }

    public String getPreviousGivenWhenThenKeyWord() {
        return this.previousGwtKeyWord;
    }

    public String getText() {
        return this.pickleStep.getText();
    }

    public String getId() {
        return this.pickleStep.getId();
    }
}

