/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Location;
import io.cucumber.messages.Messages;
import java.util.Objects;

final class GherkinMessagesLocation
implements Location {
    private final int line;
    private final int column;

    private GherkinMessagesLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    static Location from(Messages.Location location) {
        return new GherkinMessagesLocation(location.getLine(), location.getColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinMessagesLocation that = (GherkinMessagesLocation)o;
        return this.line == that.line && this.column == that.column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }
}

