/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.CucumberQuery;
import io.cucumber.core.gherkin.messages.GherkinMessagesFeature;
import io.cucumber.core.gherkin.messages.GherkinMessagesPickle;
import io.cucumber.core.gherkin.messages.internal.gherkin.Gherkin;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialectProvider;
import io.cucumber.core.gherkin.messages.internal.gherkin.ParserException;
import io.cucumber.messages.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GherkinMessagesFeatureParser
implements FeatureParser {
    public Feature parse(URI path, String source, Supplier<UUID> idGenerator) {
        try {
            CucumberQuery cucumberQuery = new CucumberQuery();
            List<Messages.Envelope> sources = Collections.singletonList(Gherkin.makeSourceEnvelope(source, path.toString()));
            List<Messages.Envelope> envelopes = Gherkin.fromSources(sources, true, true, true, () -> ((UUID)idGenerator.get()).toString()).collect(Collectors.toList());
            GherkinDialect dialect = null;
            Messages.GherkinDocument gherkinDocument = null;
            ArrayList<Pickle> pickles = new ArrayList<Pickle>();
            for (Messages.Envelope envelope : envelopes) {
                if (envelope.hasGherkinDocument()) {
                    gherkinDocument = envelope.getGherkinDocument();
                    cucumberQuery.update(gherkinDocument);
                    GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
                    String language = gherkinDocument.getFeature().getLanguage();
                    dialect = dialectProvider.getDialect(language, null);
                }
                if (!envelope.hasPickle()) continue;
                Messages.Pickle pickle = envelope.getPickle();
                pickles.add(new GherkinMessagesPickle(pickle, path, dialect, cucumberQuery));
            }
            return new GherkinMessagesFeature(gherkinDocument, path, source, pickles, envelopes);
        }
        catch (ParserException e) {
            throw new FeatureParserException("Failed to parse resource at: " + path.toString(), (Throwable)e);
        }
    }

    public String version() {
        return "8";
    }
}

