/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages.internal.gherkin.pickles;

import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PickleCompiler {
    private final IdGenerator idGenerator;

    public PickleCompiler(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public List<Messages.Pickle> compile(Messages.GherkinDocument gherkinDocument, String uri) {
        ArrayList<Messages.Pickle> pickles = new ArrayList<Messages.Pickle>();
        Messages.GherkinDocument.Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return pickles;
        }
        String language = feature.getLanguage();
        this.compileFeature(pickles, feature, language, uri);
        return pickles;
    }

    private void compileFeature(List<Messages.Pickle> pickles, Messages.GherkinDocument.Feature feature, String language, String uri) {
        List tags = feature.getTagsList();
        ArrayList<Messages.GherkinDocument.Feature.Step> featureBackgroundSteps = new ArrayList<Messages.GherkinDocument.Feature.Step>();
        for (Messages.GherkinDocument.Feature.FeatureChild child : feature.getChildrenList()) {
            if (child.hasBackground()) {
                featureBackgroundSteps.addAll(child.getBackground().getStepsList());
                continue;
            }
            if (child.hasRule()) {
                this.compileRule(pickles, child.getRule(), tags, featureBackgroundSteps, language, uri);
                continue;
            }
            Messages.GherkinDocument.Feature.Scenario scenario = child.getScenario();
            if (scenario.getExamplesList().isEmpty()) {
                this.compileScenario(pickles, scenario, tags, featureBackgroundSteps, language, uri);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, tags, featureBackgroundSteps, language, uri);
        }
    }

    private void compileRule(List<Messages.Pickle> pickles, Messages.GherkinDocument.Feature.FeatureChild.Rule rule, List<Messages.GherkinDocument.Feature.Tag> tags, List<Messages.GherkinDocument.Feature.Step> featureBackgroundSteps, String language, String uri) {
        ArrayList<Messages.GherkinDocument.Feature.Step> ruleBackgroundSteps = new ArrayList<Messages.GherkinDocument.Feature.Step>(featureBackgroundSteps);
        for (Messages.GherkinDocument.Feature.FeatureChild.RuleChild child : rule.getChildrenList()) {
            if (child.hasBackground()) {
                ruleBackgroundSteps.addAll(child.getBackground().getStepsList());
                continue;
            }
            Messages.GherkinDocument.Feature.Scenario scenario = child.getScenario();
            if (scenario.getExamplesList().isEmpty()) {
                this.compileScenario(pickles, scenario, tags, ruleBackgroundSteps, language, uri);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, tags, ruleBackgroundSteps, language, uri);
        }
    }

    private void compileScenario(List<Messages.Pickle> pickles, Messages.GherkinDocument.Feature.Scenario scenario, List<Messages.GherkinDocument.Feature.Tag> parentTags, List<Messages.GherkinDocument.Feature.Step> backgroundSteps, String language, String uri) {
        ArrayList<Messages.Pickle.PickleStep> steps = new ArrayList<Messages.Pickle.PickleStep>();
        if (!scenario.getStepsList().isEmpty()) {
            steps.addAll(this.pickleSteps(backgroundSteps));
        }
        steps.addAll(this.pickleSteps(scenario.getStepsList()));
        ArrayList<Messages.GherkinDocument.Feature.Tag> scenarioTags = new ArrayList<Messages.GherkinDocument.Feature.Tag>();
        scenarioTags.addAll(parentTags);
        scenarioTags.addAll(scenario.getTagsList());
        List<Messages.Pickle.PickleTag> pickleTags = this.pickleTags(scenarioTags);
        List<String> sourceIds = Collections.singletonList(scenario.getId());
        Messages.Pickle pickle = Messages.Pickle.newBuilder().setId(this.idGenerator.newId()).setUri(uri).setName(scenario.getName()).setLanguage(language).addAllSteps(steps).addAllTags(pickleTags).addAllAstNodeIds(sourceIds).build();
        pickles.add(pickle);
    }

    private void compileScenarioOutline(List<Messages.Pickle> pickles, Messages.GherkinDocument.Feature.Scenario scenario, List<Messages.GherkinDocument.Feature.Tag> featureTags, List<Messages.GherkinDocument.Feature.Step> backgroundSteps, String language, String uri) {
        for (Messages.GherkinDocument.Feature.Scenario.Examples examples : scenario.getExamplesList()) {
            if (examples.getTableHeader() == null) continue;
            List variableCells = examples.getTableHeader().getCellsList();
            for (Messages.GherkinDocument.Feature.TableRow valuesRow : examples.getTableBodyList()) {
                List valueCells = valuesRow.getCellsList();
                ArrayList<Messages.Pickle.PickleStep> steps = new ArrayList<Messages.Pickle.PickleStep>();
                if (!scenario.getStepsList().isEmpty()) {
                    steps.addAll(this.pickleSteps(backgroundSteps));
                }
                ArrayList<Messages.GherkinDocument.Feature.Tag> tags = new ArrayList<Messages.GherkinDocument.Feature.Tag>();
                tags.addAll(featureTags);
                tags.addAll(scenario.getTagsList());
                tags.addAll(examples.getTagsList());
                for (Messages.GherkinDocument.Feature.Step scenarioOutlineStep : scenario.getStepsList()) {
                    Messages.Pickle.PickleStep.Builder pickleStepBuilder = this.pickleStepBuilder(scenarioOutlineStep, variableCells, valuesRow);
                    steps.add(pickleStepBuilder.build());
                }
                List<String> sourceIds = Arrays.asList(scenario.getId(), valuesRow.getId());
                Messages.Pickle pickle = Messages.Pickle.newBuilder().setId(this.idGenerator.newId()).setUri(uri).setName(this.interpolate(scenario.getName(), variableCells, valueCells)).setLanguage(language).addAllSteps(steps).addAllTags(this.pickleTags(tags)).addAllAstNodeIds(sourceIds).build();
                pickles.add(pickle);
            }
        }
    }

    private Messages.PickleStepArgument.PickleTable pickleDataTable(Messages.GherkinDocument.Feature.Step.DataTable dataTable, List<Messages.GherkinDocument.Feature.TableRow.TableCell> variableCells, List<Messages.GherkinDocument.Feature.TableRow.TableCell> valueCells) {
        List rows = dataTable.getRowsList();
        ArrayList<Messages.PickleStepArgument.PickleTable.PickleTableRow> newRows = new ArrayList<Messages.PickleStepArgument.PickleTable.PickleTableRow>(rows.size());
        for (Messages.GherkinDocument.Feature.TableRow row : rows) {
            List cells = row.getCellsList();
            ArrayList<Messages.PickleStepArgument.PickleTable.PickleTableRow.PickleTableCell> newCells = new ArrayList<Messages.PickleStepArgument.PickleTable.PickleTableRow.PickleTableCell>();
            for (Messages.GherkinDocument.Feature.TableRow.TableCell cell : cells) {
                newCells.add(Messages.PickleStepArgument.PickleTable.PickleTableRow.PickleTableCell.newBuilder().setValue(this.interpolate(cell.getValue(), variableCells, valueCells)).build());
            }
            newRows.add(Messages.PickleStepArgument.PickleTable.PickleTableRow.newBuilder().addAllCells(newCells).build());
        }
        return Messages.PickleStepArgument.PickleTable.newBuilder().addAllRows(newRows).build();
    }

    private Messages.PickleStepArgument.PickleDocString pickleDocString(Messages.GherkinDocument.Feature.Step.DocString docString, List<Messages.GherkinDocument.Feature.TableRow.TableCell> variableCells, List<Messages.GherkinDocument.Feature.TableRow.TableCell> valueCells) {
        return Messages.PickleStepArgument.PickleDocString.newBuilder().setContent(this.interpolate(docString.getContent(), variableCells, valueCells)).setContentType((String)Objects.requireNonNull(docString.getContentType() == null ? null : this.interpolate(docString.getContentType(), variableCells, valueCells))).build();
    }

    private Messages.Pickle.PickleStep.Builder pickleStepBuilder(Messages.GherkinDocument.Feature.Step step, List<Messages.GherkinDocument.Feature.TableRow.TableCell> variableCells, Messages.GherkinDocument.Feature.TableRow valuesRow) {
        Messages.PickleStepArgument.Builder argument;
        List valueCells = valuesRow == null ? Collections.emptyList() : valuesRow.getCellsList();
        String stepText = this.interpolate(step.getText(), variableCells, valueCells);
        Messages.Pickle.PickleStep.Builder pickleStepBuilder = Messages.Pickle.PickleStep.newBuilder().setId(this.idGenerator.newId()).addAstNodeIds(step.getId()).setText(stepText);
        if (valuesRow != null) {
            pickleStepBuilder.addAstNodeIds(valuesRow.getId());
        }
        if (step.hasDataTable()) {
            argument = Messages.PickleStepArgument.newBuilder();
            argument.setDataTable(this.pickleDataTable(step.getDataTable(), variableCells, valueCells));
            pickleStepBuilder.setArgument(argument);
        }
        if (step.hasDocString()) {
            argument = Messages.PickleStepArgument.newBuilder();
            argument.setDocString(this.pickleDocString(step.getDocString(), variableCells, valueCells));
            pickleStepBuilder.setArgument(argument);
        }
        return pickleStepBuilder;
    }

    private List<Messages.Pickle.PickleStep> pickleSteps(List<Messages.GherkinDocument.Feature.Step> steps) {
        ArrayList<Messages.Pickle.PickleStep> result = new ArrayList<Messages.Pickle.PickleStep>();
        for (Messages.GherkinDocument.Feature.Step step : steps) {
            result.add(this.pickleStep(step));
        }
        return Collections.unmodifiableList(result);
    }

    private Messages.Pickle.PickleStep pickleStep(Messages.GherkinDocument.Feature.Step step) {
        Messages.Pickle.PickleStep.Builder pickleStepBuilder = this.pickleStepBuilder(step, Collections.emptyList(), null);
        return pickleStepBuilder.build();
    }

    private String interpolate(String name, List<Messages.GherkinDocument.Feature.TableRow.TableCell> variableCells, List<Messages.GherkinDocument.Feature.TableRow.TableCell> valueCells) {
        int col = 0;
        for (Messages.GherkinDocument.Feature.TableRow.TableCell variableCell : variableCells) {
            Messages.GherkinDocument.Feature.TableRow.TableCell valueCell = valueCells.get(col++);
            String header = variableCell.getValue();
            String value = valueCell.getValue();
            name = name.replace("<" + header + ">", value);
        }
        return name;
    }

    private List<Messages.Pickle.PickleTag> pickleTags(List<Messages.GherkinDocument.Feature.Tag> tags) {
        ArrayList<Messages.Pickle.PickleTag> result = new ArrayList<Messages.Pickle.PickleTag>();
        for (Messages.GherkinDocument.Feature.Tag tag : tags) {
            result.add(this.pickleTag(tag));
        }
        return result;
    }

    private Messages.Pickle.PickleTag pickleTag(Messages.GherkinDocument.Feature.Tag tag) {
        return Messages.Pickle.PickleTag.newBuilder().setName(tag.getName()).setAstNodeId(tag.getId()).build();
    }
}

