/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages.internal.gherkin;

import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialectProvider;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinLineSpan;
import io.cucumber.core.gherkin.messages.internal.gherkin.IGherkinDialectProvider;
import io.cucumber.core.gherkin.messages.internal.gherkin.Location;
import io.cucumber.core.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.core.gherkin.messages.internal.gherkin.Token;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenMatcher
implements Parser.ITokenMatcher {
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^\\s*#\\s*language\\s*:\\s*([a-zA-Z\\-_]+)\\s*$");
    private final IGherkinDialectProvider dialectProvider;
    private GherkinDialect currentDialect;
    private String activeDocStringSeparator = null;
    private int indentToRemove = 0;

    public TokenMatcher(IGherkinDialectProvider dialectProvider) {
        this.dialectProvider = dialectProvider;
        this.reset();
    }

    public TokenMatcher() {
        this(new GherkinDialectProvider());
    }

    public TokenMatcher(String defaultDialectName) {
        this(new GherkinDialectProvider(defaultDialectName));
    }

    @Override
    public void reset() {
        this.activeDocStringSeparator = null;
        this.indentToRemove = 0;
        this.currentDialect = this.dialectProvider.getDefaultDialect();
    }

    private GherkinDialect getCurrentDialect() {
        return this.currentDialect;
    }

    private void setTokenMatched(Token token, Parser.TokenType matchedType, String text, String keyword, Integer indent, List<GherkinLineSpan> items) {
        token.matchedType = matchedType;
        token.matchedKeyword = keyword;
        token.matchedText = text;
        token.mathcedItems = items;
        token.matchedGherkinDialect = this.getCurrentDialect();
        token.matchedIndent = indent != null ? indent : (token.line == null ? 0 : token.line.indent());
        token.location = new Location(token.location.getLine(), token.matchedIndent + 1);
    }

    @Override
    public boolean match_EOF(Token token) {
        if (token.isEOF()) {
            this.setTokenMatched(token, Parser.TokenType.EOF, null, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Other(Token token) {
        String text = token.line.getLineText(this.indentToRemove);
        this.setTokenMatched(token, Parser.TokenType.Other, this.unescapeDocString(text), null, 0, null);
        return true;
    }

    @Override
    public boolean match_Empty(Token token) {
        if (token.line.isEmpty()) {
            this.setTokenMatched(token, Parser.TokenType.Empty, null, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Comment(Token token) {
        if (token.line.startsWith("#")) {
            String text = token.line.getLineText(0);
            this.setTokenMatched(token, Parser.TokenType.Comment, text, null, 0, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Language(Token token) {
        Matcher matcher = LANGUAGE_PATTERN.matcher(token.line.getLineText(0));
        if (matcher.matches()) {
            String language = matcher.group(1);
            this.setTokenMatched(token, Parser.TokenType.Language, language, null, null, null);
            this.currentDialect = this.dialectProvider.getDialect(language, token.location);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_TagLine(Token token) {
        if (token.line.startsWith("@")) {
            this.setTokenMatched(token, Parser.TokenType.TagLine, null, null, null, token.line.getTags());
            return true;
        }
        return false;
    }

    @Override
    public boolean match_FeatureLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.FeatureLine, this.currentDialect.getFeatureKeywords());
    }

    @Override
    public boolean match_RuleLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.RuleLine, this.currentDialect.getRuleKeywords());
    }

    @Override
    public boolean match_BackgroundLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.BackgroundLine, this.currentDialect.getBackgroundKeywords());
    }

    @Override
    public boolean match_ScenarioLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.ScenarioLine, this.currentDialect.getScenarioKeywords()) || this.matchTitleLine(token, Parser.TokenType.ScenarioLine, this.currentDialect.getScenarioOutlineKeywords());
    }

    @Override
    public boolean match_ExamplesLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.ExamplesLine, this.currentDialect.getExamplesKeywords());
    }

    private boolean matchTitleLine(Token token, Parser.TokenType tokenType, List<String> keywords) {
        for (String keyword : keywords) {
            if (!token.line.startsWithTitleKeyword(keyword)) continue;
            String title = token.line.getRestTrimmed(keyword.length() + ":".length());
            this.setTokenMatched(token, tokenType, title, keyword, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_DocStringSeparator(Token token) {
        return this.activeDocStringSeparator == null ? this.match_DocStringSeparator(token, "\"\"\"", true) || this.match_DocStringSeparator(token, "```", true) : this.match_DocStringSeparator(token, this.activeDocStringSeparator, false);
    }

    private boolean match_DocStringSeparator(Token token, String separator, boolean isOpen) {
        if (token.line.startsWith(separator)) {
            String contentType = null;
            if (isOpen) {
                contentType = token.line.getRestTrimmed(separator.length());
                this.activeDocStringSeparator = separator;
                this.indentToRemove = token.line.indent();
            } else {
                this.activeDocStringSeparator = null;
                this.indentToRemove = 0;
            }
            this.setTokenMatched(token, Parser.TokenType.DocStringSeparator, contentType, separator, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_StepLine(Token token) {
        List<String> keywords = this.currentDialect.getStepKeywords();
        for (String keyword : keywords) {
            if (!token.line.startsWith(keyword)) continue;
            String stepText = token.line.getRestTrimmed(keyword.length());
            this.setTokenMatched(token, Parser.TokenType.StepLine, stepText, keyword, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_TableRow(Token token) {
        if (token.line.startsWith("|")) {
            this.setTokenMatched(token, Parser.TokenType.TableRow, null, null, null, token.line.getTableCells());
            return true;
        }
        return false;
    }

    private String unescapeDocString(String text) {
        return this.activeDocStringSeparator != null ? text.replace("\\\"\\\"\\\"", "\"\"\"") : text;
    }
}

