/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages.internal.gherkin;

import java.util.Iterator;

public class StringUtils {
    static String ltrim(String s) {
        return s.replaceAll("^[ \\t\\n\\x0B\\f\\r\\x85\\xA0]+", "");
    }

    static String rtrim(String s) {
        return s.replaceAll("[ \\t\\n\\x0B\\f\\r\\x85\\xA0]+$", "");
    }

    static String trim(String s) {
        return StringUtils.ltrim(StringUtils.rtrim(s));
    }

    public static int symbolCount(String string) {
        return string.codePointCount(0, string.length());
    }

    static Iterable<String> codePoints(final String string) {
        return () -> new Iterator<String>(){
            int nextIndex = 0;

            @Override
            public boolean hasNext() {
                return this.nextIndex < string.length();
            }

            @Override
            public String next() {
                int codePoint = string.codePointAt(this.nextIndex);
                this.nextIndex += Character.charCount(codePoint);
                return StringUtils.codePointToString(codePoint);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static String codePointToString(int cp) {
        StringBuilder sb = new StringBuilder();
        if (Character.isBmpCodePoint(cp)) {
            sb.append((char)cp);
        } else if (Character.isValidCodePoint(cp)) {
            sb.append(Character.highSurrogate(cp));
            sb.append(Character.lowSurrogate(cp));
        } else {
            sb.append('?');
        }
        return sb.toString();
    }
}

