/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages.internal.gherkin;

import io.cucumber.core.gherkin.messages.internal.gherkin.AstNode;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinLineSpan;
import io.cucumber.core.gherkin.messages.internal.gherkin.Location;
import io.cucumber.core.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.core.gherkin.messages.internal.gherkin.ParserException;
import io.cucumber.core.gherkin.messages.internal.gherkin.Token;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.Messages;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;

public class GherkinDocumentBuilder
implements Parser.Builder<Messages.GherkinDocument.Builder> {
    private final IdGenerator idGenerator;
    private Deque<AstNode> stack;
    private Messages.GherkinDocument.Builder gherkinDocumentBuilder;

    public GherkinDocumentBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        this.reset();
    }

    @Override
    public void reset() {
        this.stack = new ArrayDeque<AstNode>();
        this.stack.push(new AstNode(Parser.RuleType.None));
        this.gherkinDocumentBuilder = Messages.GherkinDocument.newBuilder();
    }

    private AstNode currentNode() {
        return this.stack.peek();
    }

    @Override
    public void build(Token token) {
        Parser.RuleType ruleType = Parser.RuleType.cast(token.matchedType);
        if (token.matchedType == Parser.TokenType.Comment) {
            this.gherkinDocumentBuilder.addComments(Messages.GherkinDocument.Comment.newBuilder().setLocation(this.getLocation(token, 0)).setText(token.matchedText));
        } else {
            this.currentNode().add(ruleType, token);
        }
    }

    @Override
    public void startRule(Parser.RuleType ruleType) {
        this.stack.push(new AstNode(ruleType));
    }

    @Override
    public void endRule(Parser.RuleType ruleType) {
        AstNode node = this.stack.pop();
        Object transformedNode = this.getTransformedNode(node);
        this.currentNode().add(node.ruleType, transformedNode);
    }

    private Object getTransformedNode(AstNode node) {
        switch (node.ruleType) {
            case Step: {
                Messages.GherkinDocument.Feature.Step.DocString docString;
                Messages.GherkinDocument.Feature.Step.Builder builder = Messages.GherkinDocument.Feature.Step.newBuilder();
                Token stepLine = node.getToken(Parser.TokenType.StepLine);
                builder.setId(this.idGenerator.newId()).setLocation(this.getLocation(stepLine, 0)).setKeyword(stepLine.matchedKeyword).setText(stepLine.matchedText);
                Messages.GherkinDocument.Feature.Step.DataTable dataTable = node.getSingle(Parser.RuleType.DataTable, null);
                if (dataTable != null) {
                    builder.setDataTable(dataTable);
                }
                if ((docString = (Messages.GherkinDocument.Feature.Step.DocString)node.getSingle(Parser.RuleType.DocString, null)) != null) {
                    builder.setDocString(docString);
                }
                return builder.build();
            }
            case DocString: {
                Token separatorToken = node.getTokens(Parser.TokenType.DocStringSeparator).get(0);
                String contentType = separatorToken.matchedText.length() > 0 ? separatorToken.matchedText : null;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                StringBuilder content = new StringBuilder();
                boolean newLine = false;
                for (Token lineToken : lineTokens) {
                    if (newLine) {
                        content.append("\n");
                    }
                    newLine = true;
                    content.append(lineToken.matchedText);
                }
                Messages.GherkinDocument.Feature.Step.DocString.Builder builder = Messages.GherkinDocument.Feature.Step.DocString.newBuilder();
                if (contentType != null) {
                    builder.setContentType(contentType);
                }
                return builder.setLocation(this.getLocation(separatorToken, 0)).setContent(content.toString()).setDelimiter(separatorToken.matchedKeyword).build();
            }
            case DataTable: {
                List<Messages.GherkinDocument.Feature.TableRow> rows = this.getTableRows(node);
                return Messages.GherkinDocument.Feature.Step.DataTable.newBuilder().setLocation(rows.get(0).getLocation()).addAllRows(rows).build();
            }
            case Background: {
                Token backgroundLine = node.getToken(Parser.TokenType.BackgroundLine);
                String description = this.getDescription(node);
                List<Messages.GherkinDocument.Feature.Step> steps = this.getSteps(node);
                Messages.GherkinDocument.Feature.Background.Builder builder = Messages.GherkinDocument.Feature.Background.newBuilder();
                if (description != null) {
                    builder.setDescription(description);
                }
                return builder.setLocation(this.getLocation(backgroundLine, 0)).setKeyword(backgroundLine.matchedKeyword).setName(backgroundLine.matchedText).addAllSteps(steps).build();
            }
            case ScenarioDefinition: {
                List<Messages.GherkinDocument.Feature.Tag> tags = this.getTags(node);
                AstNode scenarioNode = node.getSingle(Parser.RuleType.Scenario, null);
                Token scenarioLine = scenarioNode.getToken(Parser.TokenType.ScenarioLine);
                String description = this.getDescription(scenarioNode);
                List<Messages.GherkinDocument.Feature.Step> steps = this.getSteps(scenarioNode);
                List examplesList = scenarioNode.getItems(Parser.RuleType.ExamplesDefinition);
                Messages.GherkinDocument.Feature.Scenario.Builder builder = Messages.GherkinDocument.Feature.Scenario.newBuilder();
                if (description != null) {
                    builder.setDescription(description);
                }
                return builder.setId(this.idGenerator.newId()).setLocation(this.getLocation(scenarioLine, 0)).setKeyword(scenarioLine.matchedKeyword).setName(scenarioLine.matchedText).addAllTags(tags).addAllSteps(steps).addAllExamples(examplesList).build();
            }
            case ExamplesDefinition: {
                List tableBody;
                Messages.GherkinDocument.Feature.Scenario.Examples.Builder builder = Messages.GherkinDocument.Feature.Scenario.Examples.newBuilder();
                List<Messages.GherkinDocument.Feature.Tag> tags = this.getTags(node);
                AstNode examplesNode = node.getSingle(Parser.RuleType.Examples, null);
                Token examplesLine = examplesNode.getToken(Parser.TokenType.ExamplesLine);
                String description = this.getDescription(examplesNode);
                List rows = examplesNode.getSingle(Parser.RuleType.ExamplesTable, null);
                Messages.GherkinDocument.Feature.TableRow tableHeader = rows != null && !rows.isEmpty() ? (Messages.GherkinDocument.Feature.TableRow)rows.get(0) : null;
                List list = tableBody = rows != null && !rows.isEmpty() ? rows.subList(1, rows.size()) : null;
                if (tableHeader != null) {
                    builder.setTableHeader(tableHeader);
                }
                if (tableBody != null) {
                    builder.addAllTableBody(tableBody);
                }
                builder.setLocation(this.getLocation(examplesLine, 0)).setKeyword(examplesLine.matchedKeyword).setName(examplesLine.matchedText).addAllTags(tags);
                if (description != null) {
                    builder.setDescription(description);
                }
                return builder.build();
            }
            case ExamplesTable: {
                return this.getTableRows(node);
            }
            case Description: {
                int end;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                for (end = lineTokens.size(); end > 0 && lineTokens.get((int)(end - 1)).matchedText.matches("\\s*"); --end) {
                }
                lineTokens = lineTokens.subList(0, end);
                return lineTokens.stream().map(t -> t.matchedText).collect(Collectors.joining("\n"));
            }
            case Feature: {
                Messages.GherkinDocument.Feature.Builder builder = Messages.GherkinDocument.Feature.newBuilder();
                AstNode header = node.getSingle(Parser.RuleType.FeatureHeader, new AstNode(Parser.RuleType.FeatureHeader));
                if (header == null) {
                    return null;
                }
                List<Messages.GherkinDocument.Feature.Tag> tags = this.getTags(header);
                Token featureLine = header.getToken(Parser.TokenType.FeatureLine);
                if (featureLine == null) {
                    return null;
                }
                Messages.GherkinDocument.Feature.Background background = node.getSingle(Parser.RuleType.Background, null);
                if (background != null) {
                    builder.addChildren(Messages.GherkinDocument.Feature.FeatureChild.newBuilder().setBackground(background).build());
                }
                for (Messages.GherkinDocument.Feature.Scenario scenario : node.getItems(Parser.RuleType.ScenarioDefinition)) {
                    builder.addChildren(Messages.GherkinDocument.Feature.FeatureChild.newBuilder().setScenario(scenario).build());
                }
                for (Messages.GherkinDocument.Feature.FeatureChild.Rule rule : node.getItems(Parser.RuleType.Rule)) {
                    builder.addChildren(Messages.GherkinDocument.Feature.FeatureChild.newBuilder().setRule(rule).build());
                }
                String description = this.getDescription(header);
                if (description != null) {
                    builder.setDescription(description);
                }
                if (featureLine.matchedGherkinDialect == null) {
                    return null;
                }
                String language = featureLine.matchedGherkinDialect.getLanguage();
                return builder.addAllTags(tags).setLocation(this.getLocation(featureLine, 0)).setLanguage(language).setKeyword(featureLine.matchedKeyword).setName(featureLine.matchedText).build();
            }
            case Rule: {
                Messages.GherkinDocument.Feature.Background background;
                Messages.GherkinDocument.Feature.FeatureChild.Rule.Builder builder = Messages.GherkinDocument.Feature.FeatureChild.Rule.newBuilder();
                AstNode header = node.getSingle(Parser.RuleType.RuleHeader, new AstNode(Parser.RuleType.RuleHeader));
                if (header == null) {
                    return null;
                }
                Token ruleLine = header.getToken(Parser.TokenType.RuleLine);
                if (ruleLine == null) {
                    return null;
                }
                String description = this.getDescription(header);
                if (description != null) {
                    builder.setDescription(description);
                }
                if ((background = (Messages.GherkinDocument.Feature.Background)node.getSingle(Parser.RuleType.Background, null)) != null) {
                    builder.addChildren(Messages.GherkinDocument.Feature.FeatureChild.RuleChild.newBuilder().setBackground(background).build());
                }
                List scenarios = node.getItems(Parser.RuleType.ScenarioDefinition);
                for (Messages.GherkinDocument.Feature.Scenario scenario : scenarios) {
                    builder.addChildren(Messages.GherkinDocument.Feature.FeatureChild.RuleChild.newBuilder().setScenario(scenario).build());
                }
                return builder.setLocation(this.getLocation(ruleLine, 0)).setKeyword(ruleLine.matchedKeyword).setName(ruleLine.matchedText).build();
            }
            case GherkinDocument: {
                Messages.GherkinDocument.Feature feature = node.getSingle(Parser.RuleType.Feature, null);
                if (feature != null) {
                    this.gherkinDocumentBuilder.setFeature(feature);
                }
                return this.gherkinDocumentBuilder;
            }
        }
        return node;
    }

    private List<Messages.GherkinDocument.Feature.TableRow> getTableRows(AstNode node) {
        ArrayList<Messages.GherkinDocument.Feature.TableRow> rows = new ArrayList<Messages.GherkinDocument.Feature.TableRow>();
        for (Token token : node.getTokens(Parser.TokenType.TableRow)) {
            rows.add(Messages.GherkinDocument.Feature.TableRow.newBuilder().setId(this.idGenerator.newId()).setLocation(this.getLocation(token, 0)).addAllCells(this.getCells(token)).build());
        }
        this.ensureCellCount(rows);
        return rows;
    }

    private void ensureCellCount(List<Messages.GherkinDocument.Feature.TableRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        int cellCount = rows.get(0).getCellsCount();
        for (Messages.GherkinDocument.Feature.TableRow row : rows) {
            if (row.getCellsCount() == cellCount) continue;
            Location location = new Location(row.getLocation().getLine(), row.getLocation().getColumn());
            throw new ParserException.AstBuilderException("inconsistent cell count within the table", location);
        }
    }

    private List<Messages.GherkinDocument.Feature.TableRow.TableCell> getCells(Token token) {
        ArrayList<Messages.GherkinDocument.Feature.TableRow.TableCell> cells = new ArrayList<Messages.GherkinDocument.Feature.TableRow.TableCell>();
        for (GherkinLineSpan cellItem : token.mathcedItems) {
            cells.add(Messages.GherkinDocument.Feature.TableRow.TableCell.newBuilder().setLocation(this.getLocation(token, cellItem.column)).setValue(cellItem.text).build());
        }
        return cells;
    }

    private List<Messages.GherkinDocument.Feature.Step> getSteps(AstNode node) {
        return node.getItems(Parser.RuleType.Step);
    }

    private Messages.Location getLocation(Token token, int column) {
        column = column == 0 ? token.location.getColumn() : column;
        return Messages.Location.newBuilder().setLine(token.location.getLine()).setColumn(column).build();
    }

    private String getDescription(AstNode node) {
        return node.getSingle(Parser.RuleType.Description, null);
    }

    private List<Messages.GherkinDocument.Feature.Tag> getTags(AstNode node) {
        AstNode tagsNode = node.getSingle(Parser.RuleType.Tags, new AstNode(Parser.RuleType.None));
        if (tagsNode == null) {
            return new ArrayList<Messages.GherkinDocument.Feature.Tag>();
        }
        List<Token> tokens = tagsNode.getTokens(Parser.TokenType.TagLine);
        ArrayList<Messages.GherkinDocument.Feature.Tag> tags = new ArrayList<Messages.GherkinDocument.Feature.Tag>();
        for (Token token : tokens) {
            for (GherkinLineSpan tagItem : token.mathcedItems) {
                tags.add(Messages.GherkinDocument.Feature.Tag.newBuilder().setLocation(this.getLocation(token, tagItem.column)).setName(tagItem.text).setId(this.idGenerator.newId()).build());
            }
        }
        return tags;
    }

    @Override
    public Messages.GherkinDocument.Builder getResult() {
        return this.currentNode().getSingle(Parser.RuleType.GherkinDocument, null);
    }
}

