/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages.internal.gherkin;

import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDocumentBuilder;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinException;
import io.cucumber.core.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.core.gherkin.messages.internal.gherkin.ParserException;
import io.cucumber.core.gherkin.messages.internal.gherkin.pickles.PickleCompiler;
import io.cucumber.messages.BinaryToMessageIterable;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.Messages;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Gherkin {
    private final List<String> paths;
    private final List<Messages.Envelope> envelopes;
    private final boolean includeSource;
    private final boolean includeAst;
    private final boolean includePickles;
    private final IdGenerator idGenerator;

    private Gherkin(List<String> paths, List<Messages.Envelope> envelopes, boolean includeSource, boolean includeAst, boolean includePickles, IdGenerator idGenerator) {
        this.paths = paths;
        this.envelopes = envelopes;
        this.includeSource = includeSource;
        this.includeAst = includeAst;
        this.includePickles = includePickles;
        this.idGenerator = idGenerator;
    }

    public static Stream<Messages.Envelope> fromPaths(List<String> paths, boolean includeSource, boolean includeAst, boolean includePickles, IdGenerator idGenerator) {
        return new Gherkin(paths, null, includeSource, includeAst, includePickles, idGenerator).messages();
    }

    public static Stream<Messages.Envelope> fromSources(List<Messages.Envelope> envelopes, boolean includeSource, boolean includeAst, boolean includePickles, IdGenerator idGenerator) {
        return new Gherkin(Collections.emptyList(), envelopes, includeSource, includeAst, includePickles, idGenerator).messages();
    }

    public static Stream<Messages.Envelope> fromStream(InputStream in) {
        BinaryToMessageIterable envelopeIterable = new BinaryToMessageIterable(in);
        return StreamSupport.stream(envelopeIterable.spliterator(), false);
    }

    public static Messages.Envelope makeSourceEnvelope(String data, String uri) {
        return Messages.Envelope.newBuilder().setSource(Messages.Source.newBuilder().setData(data).setUri(uri).setMedia(Messages.Media.newBuilder().setEncoding(Messages.Media.Encoding.UTF8).setContentType("text/x.cucumber.gherkin+plain"))).build();
    }

    public Stream<Messages.Envelope> messages() {
        Stream<Object> envelopeStream = this.envelopes != null ? this.envelopes.stream() : this.envelopeStreamFromPaths(this.paths);
        return envelopeStream.flatMap(envelope -> this.parserMessageStream((Messages.Envelope)envelope, this.includeSource, this.includeAst, this.includePickles));
    }

    private Stream<Messages.Envelope> envelopeStreamFromPaths(List<String> paths) {
        return paths.stream().map(this::envelopeFromPath);
    }

    private Messages.Envelope envelopeFromPath(String path) {
        try {
            String data = Gherkin.read(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            return Gherkin.makeSourceEnvelope(data, path);
        }
        catch (IOException e) {
            throw new GherkinException(e.getMessage(), e);
        }
    }

    private static String read(Reader reader) throws IOException {
        int read;
        char[] buffer = new char[65536];
        StringBuilder sb = new StringBuilder();
        do {
            if ((read = reader.read(buffer, 0, buffer.length)) <= 0) continue;
            sb.append(buffer, 0, read);
        } while (read >= 0);
        return sb.toString();
    }

    private Stream<Messages.Envelope> parserMessageStream(Messages.Envelope envelope, boolean includeSource, boolean includeGherkinDocument, boolean includePickles) {
        ArrayList<Messages.Envelope> messages = new ArrayList<Messages.Envelope>();
        if (includeSource) {
            messages.add(envelope);
        }
        if (envelope.hasSource()) {
            Parser<Messages.GherkinDocument.Builder> parser = new Parser<Messages.GherkinDocument.Builder>(new GherkinDocumentBuilder(this.idGenerator));
            Messages.Source source = envelope.getSource();
            String uri = source.getUri();
            String data = source.getData();
            try {
                Messages.GherkinDocument gherkinDocument = null;
                if (includeGherkinDocument) {
                    gherkinDocument = parser.parse(data).setUri(uri).build();
                    messages.add(Messages.Envelope.newBuilder().setGherkinDocument(gherkinDocument).build());
                }
                if (includePickles) {
                    if (gherkinDocument == null) {
                        gherkinDocument = parser.parse(data).setUri(uri).build();
                    }
                    PickleCompiler pickleCompiler = new PickleCompiler(this.idGenerator);
                    List<Messages.Pickle> pickles = pickleCompiler.compile(gherkinDocument, uri);
                    for (Messages.Pickle pickle : pickles) {
                        messages.add(Messages.Envelope.newBuilder().setPickle(pickle).build());
                    }
                }
            }
            catch (ParserException.CompositeParserException e) {
                for (ParserException error : e.errors) {
                    this.addErrorAttachment(messages, error, uri);
                }
            }
            catch (ParserException e) {
                this.addErrorAttachment(messages, e, uri);
            }
        }
        return messages.stream();
    }

    private void addErrorAttachment(List<Messages.Envelope> messages, ParserException e, String uri) {
        Messages.Attachment attachment = Messages.Attachment.newBuilder().setSource(Messages.SourceReference.newBuilder().setUri(uri).setLocation(Messages.Location.newBuilder().setLine(e.location.getLine()).setColumn(e.location.getColumn()).build()).build()).setData(e.getMessage()).build();
        messages.add(Messages.Envelope.newBuilder().setAttachment(attachment).build());
    }
}

