/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.GroupBuilder;
import io.cucumber.cucumberexpressions.PatternCompilerProvider;
import java.util.ArrayDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

final class TreeRegexp {
    private final Pattern pattern;
    private final GroupBuilder groupBuilder;

    TreeRegexp(String regexp) {
        this(PatternCompilerProvider.getCompiler().compile(regexp, 256));
    }

    TreeRegexp(Pattern pattern) {
        this.pattern = pattern;
        String source = pattern.pattern();
        char[] chars = source.toCharArray();
        ArrayDeque<GroupBuilder> stack = new ArrayDeque<GroupBuilder>();
        ArrayDeque<Integer> groupStartStack = new ArrayDeque<Integer>();
        stack.push(new GroupBuilder());
        char last = '\u0000';
        boolean escaping = false;
        boolean charClass = false;
        boolean nonCapturingMaybe = false;
        int n = 1;
        for (char c : chars) {
            if (c == '[' && !escaping) {
                charClass = true;
            } else if (c == ']' && !escaping) {
                charClass = false;
            } else if (c == '(' && !escaping && !charClass) {
                stack.push(new GroupBuilder());
                groupStartStack.push(n);
                nonCapturingMaybe = false;
            } else if (c == ')' && !escaping && !charClass) {
                GroupBuilder gb = (GroupBuilder)stack.pop();
                int groupStart = (Integer)groupStartStack.pop();
                if (gb.isCapturing()) {
                    gb.setSource(source.substring(groupStart, n - 1));
                    ((GroupBuilder)stack.peek()).add(gb);
                } else {
                    gb.moveChildrenTo((GroupBuilder)stack.peek());
                }
                nonCapturingMaybe = false;
            } else if (c == '?' && last == '(') {
                nonCapturingMaybe = true;
            } else if ((c == ':' || c == '!' || c == '=' || c == '<') && last == '?' && nonCapturingMaybe) {
                ((GroupBuilder)stack.peek()).setNonCapturing();
                nonCapturingMaybe = false;
            }
            escaping = c == '\\' && !escaping;
            last = c;
            ++n;
        }
        this.groupBuilder = (GroupBuilder)stack.pop();
    }

    Pattern pattern() {
        return this.pattern;
    }

    Group match(CharSequence s) {
        Matcher matcher = this.pattern.matcher(s);
        if (!matcher.matches()) {
            return null;
        }
        return this.groupBuilder.build(matcher, IntStream.rangeClosed(0, matcher.groupCount()).iterator());
    }

    public GroupBuilder getGroupBuilder() {
        return this.groupBuilder;
    }
}

