/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.TreeRegexp;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class Argument<T> {
    private final ParameterType<T> parameterType;
    private final Group group;

    static List<Argument<?>> build(TreeRegexp treeRegexp, List<ParameterType<?>> parameterTypes, String text) {
        Group group = treeRegexp.match(text);
        if (group == null) {
            return null;
        }
        List<Group> argGroups = group.getChildren();
        if (argGroups.size() != parameterTypes.size()) {
            throw new CucumberExpressionException(String.format("Expression /%s/ has %s capture groups (%s), but there were %s parameter types (%s)", treeRegexp.pattern().pattern(), argGroups.size(), Argument.getGroupValues(argGroups), parameterTypes.size(), Argument.getParameterTypeNames(parameterTypes)));
        }
        ArrayList args = new ArrayList(argGroups.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Group argGroup = argGroups.get(i);
            ParameterType<?> parameterType = parameterTypes.get(i);
            args.add(new Argument(argGroup, parameterType));
        }
        return args;
    }

    private static List<String> getParameterTypeNames(List<ParameterType<?>> parameterTypes) {
        ArrayList<String> list = new ArrayList<String>();
        for (ParameterType<?> type : parameterTypes) {
            String name = type.getName();
            list.add(name);
        }
        return list;
    }

    private static List<Object> getGroupValues(List<Group> argGroups) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Group argGroup : argGroups) {
            String value = argGroup.getValue();
            list.add(value);
        }
        return list;
    }

    private Argument(Group group, ParameterType<T> parameterType) {
        this.group = group;
        this.parameterType = parameterType;
    }

    public Group getGroup() {
        return this.group;
    }

    public T getValue() {
        return this.parameterType.transform(this.group.getValues());
    }

    public Type getType() {
        return this.parameterType.getType();
    }
}

