/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.ParameterType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ParameterTypeMatcher
implements Comparable<ParameterTypeMatcher> {
    private final ParameterType<?> parameterType;
    private final Matcher matcher;
    private final String text;

    ParameterTypeMatcher(ParameterType<?> parameterType, Matcher matcher, String text) {
        this.parameterType = parameterType;
        this.matcher = matcher;
        this.text = text;
    }

    private static boolean isWhitespaceOrPunctuation(char c) {
        return Pattern.matches("[\\s\\p{P}]", new String(new char[]{c}));
    }

    boolean advanceToAndFind(int newMatchPos) {
        this.matcher.region(newMatchPos, this.text.length());
        while (this.matcher.find()) {
            if (this.group().isEmpty() || !this.groupMatchesFullWord()) continue;
            return true;
        }
        return false;
    }

    private boolean groupMatchesFullWord() {
        char before;
        if (this.matcher.start() > 0 && !ParameterTypeMatcher.isWhitespaceOrPunctuation(before = this.text.charAt(this.matcher.start() - 1))) {
            return false;
        }
        if (this.matcher.end() < this.text.length()) {
            char after = this.text.charAt(this.matcher.end());
            return ParameterTypeMatcher.isWhitespaceOrPunctuation(after);
        }
        return true;
    }

    int start() {
        return this.matcher.start();
    }

    String group() {
        return this.matcher.group();
    }

    @Override
    public int compareTo(ParameterTypeMatcher o) {
        int posComparison = Integer.compare(this.start(), o.start());
        if (posComparison != 0) {
            return posComparison;
        }
        int lengthComparison = Integer.compare(o.group().length(), this.group().length());
        if (lengthComparison != 0) {
            return lengthComparison;
        }
        int weightComparison = Integer.compare(o.parameterType.weight(), this.parameterType.weight());
        if (weightComparison != 0) {
            return weightComparison;
        }
        return 0;
    }

    ParameterType<?> getParameterType() {
        return this.parameterType;
    }

    public String toString() {
        return this.parameterType.getType().toString();
    }
}

