/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.GroupBuilder;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.Transformer;
import io.cucumber.cucumberexpressions.TreeRegexp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RegularExpression
implements Expression {
    private final Pattern expressionRegexp;
    private final ParameterTypeRegistry parameterTypeRegistry;
    private TreeRegexp treeRegexp;

    public RegularExpression(Pattern expressionRegexp, ParameterTypeRegistry parameterTypeRegistry) {
        this.expressionRegexp = expressionRegexp;
        this.parameterTypeRegistry = parameterTypeRegistry;
        this.treeRegexp = new TreeRegexp(expressionRegexp);
    }

    @Override
    public List<Argument<?>> match(String text) {
        ArrayList parameterTypes = new ArrayList();
        for (GroupBuilder groupBuilder : this.treeRegexp.getGroupBuilder().getChildren()) {
            String parameterTypeRegexp = groupBuilder.getSource();
            ParameterType<Object> parameterType = this.parameterTypeRegistry.lookupByRegexp(parameterTypeRegexp, this.expressionRegexp, text);
            if (parameterType == null) {
                parameterType = new ParameterType<String>(null, parameterTypeRegexp, String.class, new Transformer<String>(){

                    @Override
                    public String transform(String arg) {
                        return arg;
                    }
                });
            }
            parameterTypes.add(parameterType);
        }
        return Argument.build(this.treeRegexp, parameterTypes, text);
    }

    @Override
    public Pattern getRegexp() {
        return this.expressionRegexp;
    }

    @Override
    public String getSource() {
        return this.expressionRegexp.pattern();
    }
}

