/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.TreeRegexp;
import io.cucumber.cucumberexpressions.UndefinedParameterTypeException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberExpression
implements Expression {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([\\\\^\\[$.|?*+\\]])");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("(\\\\\\\\)?\\{([^}]+)}");
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("(\\\\\\\\)?\\(([^)]+)\\)");
    private static final Pattern ALTERNATIVE_NON_WHITESPACE_TEXT_REGEXP = Pattern.compile("([^\\s^/]+)((/[^\\s^/]+)+)");
    private static final String DOUBLE_ESCAPE = "\\\\";
    private final List<ParameterType<?>> parameterTypes = new ArrayList();
    private final String source;
    private final TreeRegexp treeRegexp;

    public CucumberExpression(String expression, ParameterTypeRegistry parameterTypeRegistry) {
        this.source = expression;
        expression = this.processEscapes(expression);
        expression = this.processOptional(expression);
        expression = this.processAlternation(expression);
        expression = this.processParameters(expression, parameterTypeRegistry);
        expression = "^" + expression + "$";
        this.treeRegexp = new TreeRegexp(expression);
    }

    private String processEscapes(String expression) {
        return ESCAPE_PATTERN.matcher(expression).replaceAll("\\\\$1");
    }

    private String processAlternation(String expression) {
        Matcher matcher = ALTERNATIVE_NON_WHITESPACE_TEXT_REGEXP.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "(?:" + matcher.group(1) + matcher.group(2).replace('/', '|') + ")");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processOptional(String expression) {
        Matcher matcher = OPTIONAL_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (DOUBLE_ESCAPE.equals(matcher.group(1))) {
                matcher.appendReplacement(sb, "\\\\(" + matcher.group(2) + "\\\\)");
                continue;
            }
            matcher.appendReplacement(sb, "(?:" + matcher.group(2) + ")?");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processParameters(String expression, ParameterTypeRegistry parameterTypeRegistry) {
        Matcher matcher = PARAMETER_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (DOUBLE_ESCAPE.equals(matcher.group(1))) {
                matcher.appendReplacement(sb, "\\\\{" + matcher.group(2) + "\\\\}");
                continue;
            }
            String typeName = matcher.group(2);
            ParameterType parameterType = parameterTypeRegistry.lookupByTypeName(typeName);
            if (parameterType == null) {
                throw new UndefinedParameterTypeException(typeName);
            }
            this.parameterTypes.add(parameterType);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.buildCaptureRegexp(parameterType.getRegexps())));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String buildCaptureRegexp(List<String> regexps) {
        StringBuilder sb = new StringBuilder("(");
        if (regexps.size() == 1) {
            sb.append(regexps.get(0));
        } else {
            boolean bar = false;
            for (String captureGroupRegexp : regexps) {
                if (bar) {
                    sb.append("|");
                }
                sb.append("(?:").append(captureGroupRegexp).append(")");
                bar = true;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<Argument<?>> match(String text) {
        return Argument.build(this.treeRegexp, this.parameterTypes, text);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Pattern getRegexp() {
        return this.treeRegexp.pattern();
    }
}

