/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.GroupBuilder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TreeRegexp {
    private static final Character[] REGEXP_CHARS = new Character[]{Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('?'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('|')};
    private final Pattern pattern;
    private final GroupBuilder groupBuilder;

    private static boolean isRegexpChar(char c) {
        return Arrays.binarySearch((Object[])REGEXP_CHARS, Character.valueOf(c)) >= 0;
    }

    TreeRegexp(String regexp) {
        this(Pattern.compile(regexp));
    }

    TreeRegexp(Pattern pattern) {
        this.pattern = pattern;
        String source = pattern.pattern();
        char[] chars = source.toCharArray();
        ArrayDeque<GroupBuilder> stack = new ArrayDeque<GroupBuilder>();
        ArrayDeque<Integer> groupStartStack = new ArrayDeque<Integer>();
        stack.push(new GroupBuilder());
        char last = '\u0000';
        boolean escaping = false;
        boolean nonCapturingMaybe = false;
        int n = 1;
        for (char c : chars) {
            if (escaping && TreeRegexp.isRegexpChar(c)) {
                escaping = false;
            } else if (c == '\\') {
                escaping = true;
            } else if (c == '(' && !escaping) {
                stack.push(new GroupBuilder());
                groupStartStack.push(n);
                nonCapturingMaybe = false;
            } else if (c == ')' && !escaping) {
                GroupBuilder gb = (GroupBuilder)stack.pop();
                int groupStart = (Integer)groupStartStack.pop();
                if (gb.isCapturing()) {
                    gb.setSource(source.substring(groupStart, n - 1));
                    ((GroupBuilder)stack.peek()).add(gb);
                } else {
                    gb.moveChildrenTo((GroupBuilder)stack.peek());
                }
                nonCapturingMaybe = false;
            } else if (c == '?' && last == '(') {
                nonCapturingMaybe = true;
            } else if (c == ':' && nonCapturingMaybe) {
                ((GroupBuilder)stack.peek()).setNonCapturing();
                nonCapturingMaybe = false;
            }
            last = c;
            ++n;
        }
        this.groupBuilder = (GroupBuilder)stack.pop();
    }

    Pattern pattern() {
        return this.pattern;
    }

    Group match(CharSequence s) {
        Matcher matcher = this.pattern.matcher(s);
        if (!matcher.matches()) {
            return null;
        }
        return this.groupBuilder.build(matcher, new IntRange(0, matcher.groupCount() + 1));
    }

    public GroupBuilder getGroupBuilder() {
        return this.groupBuilder;
    }

    private static class IntRange
    implements Iterator<Integer> {
        private final int endExclusive;
        private int n;

        public IntRange(int startInclusive, int endExclusive) {
            this.endExclusive = endExclusive;
            this.n = startInclusive;
        }

        @Override
        public boolean hasNext() {
            return this.n < this.endExclusive;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.n++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

