/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.AmbiguousParameterTypeException;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.CucumberExpressionGenerator;
import io.cucumber.cucumberexpressions.DuplicateTypeNameException;
import io.cucumber.cucumberexpressions.Function;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.NumberParser;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.SingleTransformer;
import io.cucumber.cucumberexpressions.Transformer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ParameterTypeRegistry {
    private static final List<String> INTEGER_REGEXPS = Arrays.asList(Pattern.compile("-?\\d+").pattern(), Pattern.compile("\\d+").pattern());
    private static final List<String> FLOAT_REGEXPS = Collections.singletonList(Pattern.compile("-?\\d*[.,]\\d+").pattern());
    private static final List<String> HEX_REGEXPS = Collections.singletonList(Pattern.compile("0[xX][0-9a-fA-F]{2}").pattern());
    private static final List<String> WORD_REGEXPS = Collections.singletonList(Pattern.compile("\\w+").pattern());
    private static final List<String> STRING_REGEXPS = Collections.singletonList(Pattern.compile("\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|'([^'\\\\]*(\\\\.[^'\\\\]*)*)'").pattern());
    private final Map<String, ParameterType<?>> parameterTypeByName = new HashMap();
    private final Map<String, SortedSet<ParameterType<?>>> parameterTypesByRegexp = new HashMap();

    public ParameterTypeRegistry(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        final NumberParser numberParser = new NumberParser(numberFormat);
        this.defineParameterType(new ParameterType<BigInteger>("bigint", INTEGER_REGEXPS, (Type)((Object)BigInteger.class), (Transformer<BigInteger>)new SingleTransformer<BigInteger>(new Function<String, BigInteger>(){

            @Override
            public BigInteger apply(String s) {
                return new BigInteger(s);
            }
        }), false, false));
        this.defineParameterType(new ParameterType<BigDecimal>("bigdecimal", INTEGER_REGEXPS, (Type)((Object)BigDecimal.class), (Transformer<BigDecimal>)new SingleTransformer<BigDecimal>(new Function<String, BigDecimal>(){

            @Override
            public BigDecimal apply(String s) {
                return new BigDecimal(s);
            }
        }), false, false));
        this.defineParameterType(new ParameterType<Byte>("byte", HEX_REGEXPS, (Type)((Object)Byte.class), (Transformer<Byte>)new SingleTransformer<Byte>(new Function<String, Byte>(){

            @Override
            public Byte apply(String s) {
                return Byte.decode(s);
            }
        }), false, false));
        this.defineParameterType(new ParameterType<Short>("short", INTEGER_REGEXPS, (Type)((Object)Short.class), (Transformer<Short>)new SingleTransformer<Short>(new Function<String, Short>(){

            @Override
            public Short apply(String s) {
                return Short.decode(s);
            }
        }), false, false));
        this.defineParameterType(new ParameterType<Integer>("int", INTEGER_REGEXPS, (Type)((Object)Integer.class), (Transformer<Integer>)new SingleTransformer<Integer>(new Function<String, Integer>(){

            @Override
            public Integer apply(String s) {
                return Integer.decode(s);
            }
        }), true, true));
        this.defineParameterType(new ParameterType<Long>("long", INTEGER_REGEXPS, (Type)((Object)Long.class), (Transformer<Long>)new SingleTransformer<Long>(new Function<String, Long>(){

            @Override
            public Long apply(String s) {
                return Long.decode(s);
            }
        }), false, false));
        this.defineParameterType(new ParameterType<Float>("float", FLOAT_REGEXPS, (Type)((Object)Float.class), (Transformer<Float>)new SingleTransformer<Float>(new Function<String, Float>(){

            @Override
            public Float apply(String s) {
                return Float.valueOf(numberParser.parseFloat(s));
            }
        }), false, false));
        this.defineParameterType(new ParameterType<Double>("double", FLOAT_REGEXPS, (Type)((Object)Double.class), (Transformer<Double>)new SingleTransformer<Double>(new Function<String, Double>(){

            @Override
            public Double apply(String s) {
                return numberParser.parseDouble(s);
            }
        }), true, true));
        this.defineParameterType(new ParameterType<String>("word", WORD_REGEXPS, (Type)((Object)String.class), (Transformer<String>)new SingleTransformer<String>(new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s;
            }
        }), false, false));
        this.defineParameterType(new ParameterType<String>("string", STRING_REGEXPS, (Type)((Object)String.class), (Transformer<String>)new SingleTransformer<String>(new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s.replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'");
            }
        }), true, false));
    }

    public void defineParameterType(ParameterType<?> parameterType) {
        if (this.parameterTypeByName.containsKey(parameterType.getName())) {
            throw new DuplicateTypeNameException(String.format("There is already a parameter type with name %s", parameterType.getName()));
        }
        this.parameterTypeByName.put(parameterType.getName(), parameterType);
        for (String parameterTypeRegexp : parameterType.getRegexps()) {
            SortedSet<ParameterType<?>> parameterTypes;
            if (this.parameterTypesByRegexp.get(parameterTypeRegexp) == null) {
                this.parameterTypesByRegexp.put(parameterTypeRegexp, new TreeSet());
            }
            if (!(parameterTypes = this.parameterTypesByRegexp.get(parameterTypeRegexp)).isEmpty() && parameterTypes.first().preferForRegexpMatch() && parameterType.preferForRegexpMatch()) {
                throw new CucumberExpressionException(String.format("There can only be one preferential parameter type per regexp. The regexp /%s/ is used for two preferential parameter types, {%s} and {%s}", parameterTypeRegexp, parameterTypes.first().getName(), parameterType.getName()));
            }
            parameterTypes.add(parameterType);
        }
    }

    public <T> ParameterType<T> lookupByTypeName(String typeName) {
        return this.parameterTypeByName.get(typeName);
    }

    public <T> ParameterType<T> lookupByRegexp(String parameterTypeRegexp, Pattern expressionRegexp, String text) {
        SortedSet<ParameterType<?>> parameterTypes = this.parameterTypesByRegexp.get(parameterTypeRegexp);
        if (parameterTypes == null) {
            return null;
        }
        if (parameterTypes.size() > 1 && !parameterTypes.first().preferForRegexpMatch()) {
            List<GeneratedExpression> generatedExpressions = new CucumberExpressionGenerator(this).generateExpressions(text);
            throw new AmbiguousParameterTypeException(parameterTypeRegexp, expressionRegexp, parameterTypes, generatedExpressions);
        }
        return parameterTypes.first();
    }

    public Collection<ParameterType<?>> getParameterTypes() {
        return this.parameterTypeByName.values();
    }
}

