/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Transformer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public final class ParameterType<T>
implements Comparable<ParameterType<?>> {
    private final String name;
    private final Type type;
    private final List<String> regexps;
    private final boolean preferForRegexpMatch;
    private final boolean useForSnippets;
    private final Transformer<T> transformer;

    public ParameterType(String name, List<String> regexps, Type type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        if (name == null) {
            throw new CucumberExpressionException("name cannot be null");
        }
        if (regexps == null) {
            throw new CucumberExpressionException("regexps cannot be null");
        }
        if (type == null) {
            throw new CucumberExpressionException("type cannot be null");
        }
        if (transformer == null) {
            throw new CucumberExpressionException("transformer cannot be null");
        }
        this.name = name;
        this.regexps = regexps;
        this.type = type;
        this.transformer = transformer;
        this.useForSnippets = useForSnippets;
        this.preferForRegexpMatch = preferForRegexpMatch;
    }

    public ParameterType(String name, String regexp, Class<T> type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, Collections.singletonList(regexp), type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, String regexp, Class<T> type, Transformer<T> transformer) {
        this(name, Collections.singletonList(regexp), type, transformer, true, false);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getRegexps() {
        return this.regexps;
    }

    public boolean preferForRegexpMatch() {
        return this.preferForRegexpMatch;
    }

    public boolean useForSnippets() {
        return this.useForSnippets;
    }

    public T transform(List<String> groupValues) {
        String[] groupValueArray = groupValues.toArray(new String[groupValues.size()]);
        return this.transformer.transform(groupValueArray);
    }

    @Override
    public int compareTo(ParameterType<?> o) {
        if (this.preferForRegexpMatch() && !o.preferForRegexpMatch()) {
            return -1;
        }
        if (o.preferForRegexpMatch() && !this.preferForRegexpMatch()) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }
}

