/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import java.util.ArrayList;
import java.util.List;

class CombinatorialGeneratedExpressionFactory {
    private final String expressionTemplate;
    private final List<List<ParameterType<?>>> parameterTypeCombinations;

    CombinatorialGeneratedExpressionFactory(String expressionTemplate, List<List<ParameterType<?>>> parameterTypeCombinations) {
        this.expressionTemplate = expressionTemplate;
        this.parameterTypeCombinations = parameterTypeCombinations;
    }

    List<GeneratedExpression> generateExpressions() {
        ArrayList<GeneratedExpression> generatedExpressions = new ArrayList<GeneratedExpression>();
        this.generatePermutations(generatedExpressions, 0, new ArrayList());
        return generatedExpressions;
    }

    private void generatePermutations(List<GeneratedExpression> generatedExpressions, int depth, List<ParameterType<?>> currentParameterTypes) {
        if (depth == this.parameterTypeCombinations.size()) {
            generatedExpressions.add(new GeneratedExpression(this.expressionTemplate, currentParameterTypes));
            return;
        }
        for (int i = 0; i < this.parameterTypeCombinations.get(depth).size(); ++i) {
            ArrayList newCurrentParameterTypes = new ArrayList(currentParameterTypes);
            newCurrentParameterTypes.add(this.parameterTypeCombinations.get(depth).get(i));
            this.generatePermutations(generatedExpressions, depth + 1, newCurrentParameterTypes);
        }
    }
}

