/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.GroupBuilder;
import java.util.ArrayDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

class TreeRegexp {
    private final Pattern pattern;
    private final GroupBuilder groupBuilder;

    TreeRegexp(String regexp) {
        this(Pattern.compile(regexp));
    }

    TreeRegexp(Pattern pattern) {
        this.pattern = pattern;
        char[] chars = pattern.pattern().toCharArray();
        ArrayDeque<GroupBuilder> stack = new ArrayDeque<GroupBuilder>();
        stack.push(new GroupBuilder());
        int last = 0;
        boolean nonCapturingMaybe = false;
        for (int n : chars) {
            if (n == 40 && last != 92) {
                stack.push(new GroupBuilder());
                nonCapturingMaybe = false;
            } else if (n == 41 && last != 92) {
                GroupBuilder gb = (GroupBuilder)stack.pop();
                if (gb.isCapturing()) {
                    ((GroupBuilder)stack.peek()).add(gb);
                } else {
                    gb.moveChildrenTo((GroupBuilder)stack.peek());
                }
                nonCapturingMaybe = false;
            } else if (n == 63 && last == 40) {
                nonCapturingMaybe = true;
            } else if (n == 58 && nonCapturingMaybe) {
                ((GroupBuilder)stack.peek()).setNonCapturing();
                nonCapturingMaybe = false;
            }
            last = n;
        }
        this.groupBuilder = (GroupBuilder)stack.pop();
    }

    Pattern pattern() {
        return this.pattern;
    }

    Group match(CharSequence s) {
        Matcher matcher = this.pattern.matcher(s);
        if (!matcher.matches()) {
            return null;
        }
        return this.groupBuilder.build(matcher, IntStream.range(0, matcher.groupCount() + 1).iterator());
    }
}

