/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.ParameterType;
import java.util.regex.Matcher;

class ParameterTypeMatcher
implements Comparable<ParameterTypeMatcher> {
    private final ParameterType<?> parameterType;
    private final Matcher matcher;
    private final int textLength;

    public ParameterTypeMatcher(ParameterType<?> parameterType, Matcher matcher, int textLength) {
        this.parameterType = parameterType;
        this.matcher = matcher;
        this.textLength = textLength;
    }

    public ParameterTypeMatcher advanceTo(int newMatchPos) {
        return new ParameterTypeMatcher(this.parameterType, this.matcher.region(newMatchPos, this.textLength), this.textLength);
    }

    public boolean find() {
        return this.matcher.find();
    }

    public int start() {
        return this.matcher.start();
    }

    public String group() {
        return this.matcher.group();
    }

    @Override
    public int compareTo(ParameterTypeMatcher o) {
        int posComparison = Integer.compare(this.start(), o.start());
        if (posComparison != 0) {
            return posComparison;
        }
        int lengthComparison = Integer.compare(o.group().length(), this.group().length());
        if (lengthComparison != 0) {
            return lengthComparison;
        }
        return 0;
    }

    public ParameterType<?> getParameterType() {
        return this.parameterType;
    }
}

